<?php

namespace App\Http\Controllers\Api;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Management\User\UserRepository;
use App\Models\Tenant\Management\UserProfile\UserProfileRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserApiController extends Controller
{

    protected $utilHelper;
    protected $rUserRepository;
    protected $rUserProfile;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rUserRepository = new UserRepository();
        $this->rUserProfile = new UserProfileRepository();
    }


    public function index(Request $request)
    {
        $query = $this->rUserRepository->listUser($request);
        return response()->json($query);
    }

    public function userProfile()
    {
        $query = $this->rUserProfile->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rUserRepository->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $item = $this->rUserRepository->findJoined($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rUserRepository->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function updatePassword(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rUserRepository->updatePassword($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function updateActivated(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rUserRepository->activated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function destroy($id)
    {
        try {
            $this->rUserRepository->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function searchAngucomplete(Request $request)
    {
        $text_search = $request->get('search');
        $item = $this->rUserRepository->search($text_search);

        $response = array(
            'incomplete_results' => false,
            'items' => $item,
            'total_count' => count($item));

        return response()->json($response);
    }
}
