<?php

namespace App\Http\Controllers\Api\Warehouse;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductBatch\ProductBatchRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductStock\ProductStockRepository;
use App\Models\Tenant\Warehouse\Movement\MovementRepository;
use App\Models\Tenant\Warehouse\MovementDetail\MovementDetailRepository;
use App\Models\Tenant\Warehouse\WarehouseTransfer\WarehouseTransferRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MovementWarehouseApiController extends Controller
{
    protected $utilHelper;
    protected $rMovement;
    protected $rWarehouseTransfer;
    protected $rMovementDetail;
    protected $rProductStock;
    protected $rProduct;
    protected $rProductBatch;
    protected $rProductEquivalence;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rMovement = new MovementRepository();
        $this->rMovementDetail = new MovementDetailRepository();
        $this->rProductStock = new ProductStockRepository();
        $this->rProduct = new ProductRepository();
        $this->rProductBatch = new ProductBatchRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->rWarehouseTransfer = new WarehouseTransferRepository();
    }

    public function index(Request $request)
    {

    }

    public function stockGeneral(Request $request){

        $item = $this->rProduct->listStockGeneral($request);
        return response()->json($item);
    }

    public function entry(Request $request)
    {
        $model = $this->rMovement->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);

    }

    public function output(Request $request)
    {
        $model = $this->rMovement->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);

    }

    public function transfers(Request $request)
    {
        $model = $this->rWarehouseTransfer->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);

    }

    public function storeEntry(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $entry_data = $request->get('entry');
            $detail_data = $request->get('detail');

            $entry = $this->rMovement->createEntry($entry_data);

            foreach ($detail_data as $detail) {
                $detail['warehousemovement_id'] = $entry['id'];
                $detail['product_id'] = $detail['id'];
                $detail['warehouse_id'] = $entry['warehouse_id'];
                $detal_entry = $this->rMovementDetail->createEntry($detail);

                // check if price is unit
                $stock = $detail['quantity'];
                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $stock = $equivalence['equivalence']*$detail['quantity'];

                    $detal_entry->equivalence = $equivalence['equivalence'];
                    $detal_entry->save();

                    // set unit in product stock
                    $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                    $detail['unit_id'] = $principal_equivalence['unit_id'];
                }

                // update stock product
                $detail['quantity'] = $stock;
                $detail['stock'] = $stock;
                $this->rProductStock->updatedStockByWarehouse($detail['product_id'],$detail);

                if($this->utilHelper->strToBooleanValue($detail['check_date_expiration'])){
                    $batch_product = $this->rProductBatch->checkBatchProduct($detail);
                    $detal_entry->productbatch_id = $batch_product['id'];
                    $detal_entry->save();

                    $this->rProduct->setIsControlExpiration($detail['product_id']);
                }

                // update control stock product
                $this->rProduct->setIsControlStock($detail['product_id']);
            }

            $response = array(
                'status' => 'success',
                'data' => $entry
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function storeOutput(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $output_data = $request->get('output');
            $detail_data = $request->get('detail');

            $entry = $this->rMovement->createOutput($output_data);

            foreach ($detail_data as $detail) {
                $detail['warehousemovement_id'] = $entry['id'];
                $detail['product_id'] = $detail['id'];
                $detail['warehouse_id'] = $entry['warehouse_id'];
                $detail_output =$this->rMovementDetail->createOutput($detail);

                // check if price is unit
                $stock = $detail['quantity'];
                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $stock = $equivalence['equivalence']*$detail['quantity'];

                    $detail_output->equivalence = $equivalence['equivalence'];
                    $detail_output->save();

                    // set unit in product stock
                    $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                    $detail['unit_id'] = $principal_equivalence['unit_id'];
                }

                // substract stock product
                $detail['quantity'] = $stock;
                $detail['stock'] = $stock;
                $this->rProductStock->substractStockByWarehouse($detail['product_id'],$detail);

                if($this->utilHelper->checkIsNullValue($detail['batch_id']) != null){
                    $batch_product = $this->rProductBatch->substractBatch($detail);
                    $detail_output->productbatch_id = $batch_product['id'];
                    $detail_output->save();
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $entry
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function storeTransfer(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $output_data = $request->get('output');
            $detail_data = $request->get('detail');

            $output_data['warehouseconcept_id'] = config('app.warehouseconcept_transferouput');

            // MOVEMENT OUPUT =============
            $ouput = $this->rMovement->createOutput($output_data);
            foreach ($detail_data as $detail) {
                $detail['warehousemovement_id'] = $ouput['id'];
                $detail['product_id'] = $detail['id'];
                $detail['warehouse_id'] = $ouput['warehouse_id'];
                $detail_output =$this->rMovementDetail->createOutput($detail);

                // check if price is unit
                $stock = $detail['quantity'];
                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $stock = $equivalence['equivalence']*$detail['quantity'];

                    $detail_output->equivalence = $equivalence['equivalence'];
                    $detail_output->save();

                    // set unit in product stock
                    $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                    $detail['unit_id'] = $principal_equivalence['unit_id'];
                }

                // substract stock product
                $detail['quantity'] = $stock;
                $detail['stock'] = $stock;
                $this->rProductStock->substractStockByWarehouse($detail['product_id'],$detail);

                if($this->utilHelper->checkIsNullValue($detail['batch_id']) != null){
                    $batch_product = $this->rProductBatch->substractBatch($detail);
                    $detail_output->productbatch_id = $batch_product['id'];
                    $detail_output->save();
                }
            }

            // MOVEMENT ENTRY =============
            $output_data['warehouse_id'] = $output_data['warehousdestiny_id'];
            $entry = $this->rMovement->createEntry($output_data);
            foreach ($detail_data as $detail) {
                $detail['warehousemovement_id'] = $entry['id'];
                $detail['product_id'] = $detail['id'];
                $detail['warehouse_id'] = $entry['warehouse_id'];
                $detal_entry = $this->rMovementDetail->createEntry($detail);

                // check if price is unit
                $stock = $detail['quantity'];
                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $stock = $equivalence['equivalence']*$detail['quantity'];

                    $detal_entry->equivalence = $equivalence['equivalence'];
                    $detal_entry->save();

                    // set unit in product stock
                    $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                    $detail['unit_id'] = $principal_equivalence['unit_id'];
                }

                // update stock product
                $detail['quantity'] = $stock;
                $detail['stock'] = $stock;
                $this->rProductStock->updatedStockByWarehouse($detail['product_id'],$detail);

                // default value
                $detail['check_date_expiration'] = false;

                if($this->utilHelper->strToBooleanValue($detail['check_date_expiration'])){
                    $batch_product = $this->rProductBatch->checkBatchProduct($detail);
                    $detal_entry->productbatch_id = $batch_product['id'];
                    $detal_entry->save();

                    $this->rProduct->setIsControlExpiration($detail['product_id']);
                }

                // update control stock product
                $this->rProduct->setIsControlStock($detail['product_id']);
            }

            // register movement transfer
            $data_transfer = array(
                'movemententry_id'=>$entry->id,
                'movementouput_id'=>$ouput->id,
                'warehouseorigin_id'=>$output_data['warehouse_id'],
                'warehousdestiny_id'=>$output_data['warehousdestiny_id'],
                'warehouseconcept_id'=>config('app.warehouseconcept_transferentry'),
                'date_transfer'=> $output_data['date_movement'],
                'reason'=> $output_data['reason'],
            );

            $this->rWarehouseTransfer->create($data_transfer);

            $response = array(
                'status' => 'success',
                'data' => $ouput
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function detail($id)
    {

        $order = $this->rMovement->find($id);
        $order_detail = $this->rMovementDetail->findByMovementIdJoined($id);

        $result = array(
            'movement' => $order,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }


    public function destroyEntry($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $movement = $this->rMovement->find($id);
            $detail_output = $this->rMovementDetail->getDetailbyMovement($id);

            foreach ($detail_output as $detail) {
                $product = $this->rProduct->find($detail['product_id']);

                $detail['stock'] = $detail['quantity'];

                if($product['typeprice_id'] == config('app.catalog_price_unit') ){
                    $detail['quantity'] = $detail['quantity'] * $detail['equivalence'];
                    $detail['stock'] = $detail['quantity'];
                }

                // substract product batch
                if($detail['productbatch_id'] != null){
                    $this->rProductBatch->substractBatchProduct($detail['productbatch_id'], $detail);
                }

                // update stock product
                $this->rProductStock->substractStockByWarehouse($detail['product_id'],$detail, true);
            }

            $this->rMovement->deleted($id);


            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function destroyOutput($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $movement = $this->rMovement->find($id);

            $detail_output = $this->rMovementDetail->getDetailbyMovement($id);

            foreach ($detail_output as $detail) {
                $product = $this->rProduct->find($detail['product_id']);

                $detail['stock'] = $detail['quantity'];

                if($product['typeprice_id'] == config('app.catalog_price_unit') ){
                    $detail['quantity'] = $detail['quantity'] * $detail['equivalence'];
                    $detail['stock'] = $detail['quantity'];
                }

                // sum product batch
                if($detail['productbatch_id'] != null){
                    $this->rProductBatch->increaseBatchProduct($detail['productbatch_id'], $detail);
                }

                // update stock product
                $this->rProductStock->updatedStockByWarehouse($detail['product_id'],$detail);
            }

            $this->rMovement->deleted($id);


            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function destroy($id)
    {
        //
    }
}
