<?php

namespace App\Http\Controllers\Api\Warehouse;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Warehouse\Warehouse\WarehouseRepository;
use App\Models\Tenant\Warehouse\WarehouseConcept\WarehouseConceptRepository;
use Illuminate\Http\Request;

class WarehouseApiController extends Controller
{

    protected $utilHelper;
    protected $rWarehouse;
    protected $rWarehouseConcept;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rWarehouse = new WarehouseRepository();
        $this->rWarehouseConcept = new WarehouseConceptRepository();
    }

    public function index(Request $request)
    {
        $model = $this->rWarehouse->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function warehousePrincipal(){
        $item = $this->rWarehouse->warehousePrincipal();
        $response = array(
            'total' => count($item),
            'results' => $item
        );
        return response()->json($response);
    }


    public function warehouseBranchOffice(){
        $item = $this->rWarehouse->warehouseBranchOffice();
        $response = array(
            'total' => count($item),
            'results' => $item
        );
        return response()->json($response);
    }

    public function warehouseConceptEntry(){
        $item = $this->rWarehouseConcept->warehouseConceptEntry();
        $response = array(
            'total' => count($item),
            'results' => $item
        );
        return response()->json($response);
    }

    public function warehouseConceptOutput(){
        $item = $this->rWarehouseConcept->warehouseConceptOutput();
        $response = array(
            'total' => count($item),
            'results' => $item
        );
        return response()->json($response);
    }



    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
