<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
//    protected $redirectTo = RouteServiceProvider::HOME;

    protected $loginPath = '/login';
//    protected $redirectTo = '/empresas';
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }



    public function login()
    {
//        $hostname  = app(\Hyn\Tenancy\Environment::class)->hostname();
//
//        if(config('app.is_maintenance')===true){
//            return view("maintenance");
//        }
//
//        if($hostname){
//            if($hostname->is_maintenance === true){
//                return view("maintenance");
//            }
//            return view("login.login");
//        }
//        else{
//            return view("login.login");
//        }

        return view("login.login");
    }

    public function postLogin(Request $request)
    {

        $this->validate($request, [
            'email' => 'required|email', 'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials, $request->has('remember'))) {

            $hostname  = app(\Hyn\Tenancy\Environment::class)->hostname();

            if(Auth::user()->deleted_at == null){
                if($hostname){
                    return redirect()->route('tenant.company.branchoffice');

                }else{
                    return redirect()->intended($this->redirectPath());
                }
            }else{
                $this->logout();
            }


        }

        return redirect($this->loginPath)
            ->withInput($request->only('email', 'remember'))
            ->withErrors([
                'email' => $this->getFailedLoginMessage(),
            ]);
    }

    protected function getFailedLoginMessage()
    {
        return Lang::has('auth.failed')? Lang::get('auth.failed'): 'Las credenciales de acceso no coinciden.';
    }

    public function logout()
    {
        Auth::logout();
        return redirect("login");
    }

}
