<?php

namespace App\Http\Controllers;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Models\Tenant\Billing\NoteDocument\NoteDocumentRepository;
use App\Models\Tenant\Billing\NoteDocumentDetail\NoteDocumentDetailRepository;
use App\Models\Tenant\Branch\BranchConfig\BranchConfigRepository;
use App\Models\Tenant\Branch\BranchOffice\BranchOfficeRepository;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductVariant\ProductVariantRepository;
use App\Models\Tenant\Config\PaymentMethod\PaymentMethodRepository;
use App\Models\Tenant\Config\TypeVoucher\TypeVoucherRepository;
use App\Models\Tenant\Config\UnitMeasure\UnitMeasureRepository;
use App\Models\Tenant\Finance\AccountBank\AccountBankRepository;
use App\Models\Tenant\Money\MoneyConcept\MoneyConceptRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Purchase\OrderDetailPurchase\OrderDetailPurchaseRepository;
use App\Models\Tenant\Purchase\OrderPurchase\OrderPurchaseRepository;
use App\Models\Tenant\Purchase\Provider\ProviderRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Order\OrderRepository;
use App\Models\Tenant\Sale\OrderDetail\OrderDetailRepository;
use App\Models\Tenant\Sale\Proforma\ProformaRepository;
use App\Models\Tenant\Sale\ProformaDetail\ProformaDetailRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Sale\SaleDelivery\SaleDeliveryRepository;
use App\Models\Tenant\Sale\SaleDetail\SaleDetailRepository;
use App\Models\Tenant\Sale\SalePaid\SalePaidRepository;
use App\Models\Tenant\Sale\ScheduleSale\ScheduleSale;
use App\Models\Tenant\Sale\ScheduleSale\ScheduleSaleRepository;
use App\Models\Tenant\Sale\ScheduleSaleDetail\ScheduleSaleDetail;
use App\Models\Tenant\Sale\ScheduleSaleDetail\ScheduleSaleDetailRepository;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

use PDF;
//use QRCode;

class GenerateDocumentPdf extends Controller
{
    protected $tenant;
    protected $rSale;
    protected $rClient;
    protected $rProvider;
    protected $rSaleDetail;
    protected $rSalePaid;
    protected $rPaymentMethod;
    protected $rUnitMeasure;
    protected $rProduct;
    protected $rTypeVoucher;
    protected $rMoneyMovement;
    protected $rBranchOffice;
    protected $utilHelper;
    protected $rMoneyConcept;
    protected $rBranchConfig;
    protected $rProforma;
    protected $rProformaDetail;
    protected $rAccountBank;
    protected $rOrderPurchase;
    protected $rOrderDetailPurchase;
    protected $rOrder;
    protected $rOrderDetail;
    protected $rProductVariant;
    protected $rNoteDocument;
    protected $rNoteDocumentDetail;
    protected $rBillingCode;

    protected $rScheduleSale;
    protected $rScheduleSaleDetail;


    public function __construct()
    {
        $this->tenant = new TenantCore();
        $this->utilHelper = new UtilHelper();
        $this->rSale = new SaleRepository();
        $this->rClient = new ClientRepository();
        $this->rProvider = new ProviderRepository();
        $this->rSaleDetail = new SaleDetailRepository();
        $this->rSalePaid = new SalePaidRepository();
        $this->rPaymentMethod = new PaymentMethodRepository();
        $this->rUnitMeasure = new UnitMeasureRepository();
        $this->rProduct = new ProductRepository();
        $this->rTypeVoucher = new TypeVoucherRepository();
        $this->rMoneyMovement = new MovementRepository();
        $this->rBranchOffice = new BranchOfficeRepository();
        $this->rMoneyConcept = new MoneyConceptRepository();
        $this->rBranchConfig = new BranchConfigRepository();
        $this->rProforma = new ProformaRepository();
        $this->rProformaDetail = new ProformaDetailRepository();
        $this->rAccountBank = new AccountBankRepository();
        $this->rOrderPurchase = new OrderPurchaseRepository();
        $this->rOrderDetailPurchase = new OrderDetailPurchaseRepository();
        $this->rOrder = new OrderRepository();
        $this->rOrderDetail = new OrderDetailRepository();
        $this->rProductVariant = new ProductVariantRepository();
        $this->rNoteDocument = new NoteDocumentRepository();
        $this->rNoteDocumentDetail = new NoteDocumentDetailRepository();

        $this->rScheduleSale = new ScheduleSaleRepository();
        $this->rScheduleSaleDetail = new ScheduleSaleDetailRepository();


    }

    public function printBilling($sale_id, $send_email = false)
    {

        $company = $this->tenant->company();
        $sale = $this->rSale->find($sale_id);
        $detail = $this->rSaleDetail->findBySale($sale['id']);
        $movement = $this->rSalePaid->model()
            ->join('sale_amortizations', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->join('money_movements', 'sale_amortizations.moneymovement_id', '=', 'money_movements.id')
            ->select('money_movements.*')
            ->where('sale_paid.sale_id', $sale_id)
//            ->where('money_movements.voucher_id', $voucher_id)
//            ->where('money_movements.billing_external_id', '!=', null)
            ->where('money_movements.deleted_at', null)
            ->first();

        $voucher = $this->rTypeVoucher->find($movement['voucher_id']);

        $client = $this->rClient->find($sale['client_id']);

        // CONFIG ONLY COMPANY NAKAES CORP | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_nakaes')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = 'nakaes_laboratorio.jpg';
                $company['tradename'] = 'LABORATORIO CLÍNICO MELGOLAB';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'nakaes_inmobiliaria.png';
                $company['tradename'] = 'NAKAES INMOBILIARIA';
                $company['email'] = 'nakaescorporacion@gmail.com';
            }
        }
        // ===========

        // CONFIG ONLY COMPANY TATOHITO AND DANIEL ALCIDES  | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_tatohito')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = 'daniel_alcides.jpeg';
                $company['address'] = 'JR. PROGRESO #304';
                $company['tradename'] = 'CLINICA DANIEL ALCIDES CARRION';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'clinica_tatohito.png';
                $company['address'] = 'JR. MARAÑON #203';
                $company['tradename'] = 'LABORATORIO CLINICO TATOHITO';
                $company['email'] = '-';
            }
        }
        // ===========

        // CONFIG ONLY COMPANY ARILITH  | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_arilith')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = 'agua_arilith.jpg';
                $company['address'] = 'Calle Humbolt N° 411-A - Barrio Las Flores Yurimaguas';
                $company['tradename'] = 'AGUA DE MESA ARELITH';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'polleria_arilith.jpg';
                $company['address'] = 'Calle Las Americas #323 - Yurimaguas';
                $company['tradename'] = 'AVICOLA Y PROVEDURIA ARILITH';
                $company['email'] = '-';
            }
        }
        // ===========


        // CONFIG ONLY COMPANY NOVEDADES ROSITA | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_novedadesrosita')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = '10457644758.png';
                $company['address'] = 'JR. ALONSO DE ALVARADO #424';
                $company['tradename'] = 'NOVEDADES ROSITA';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'default.jpg';
                $company['address'] = 'JR. ALONSO DE ALVARADO #597        ';
                $company['tradename'] = 'NOVEDADES K&N';
                $company['email'] = '-';
            }
        }
        // ===========


        // CUSTOM TOTALES
        $total_exonerada = $sale['subtotal'];
        $total_taxed = "0.00";
        $total_gravada = "0.00";
        $title_ticket = "OP.EXONERADAS";

        $is_exonerada = false;

        if ($company->typebilling_id == config('app.billing_gravada')) {
            $is_exonerada = true;
        }

        // config store hostignet bellavista =============
        $branchoofice_id = $this->utilHelper->getBranchOffice();
        $database = $this->tenant->database();

        if($database == config("app.database_hostingnet")){
            if($branchoofice_id == 2){
                $is_exonerada = true;
            }
        }
        // ==============================

        if ($is_exonerada == true) {
            $total_exonerada = '0.00';
            $total_gravada =  $sale['subtotal'];
            $total_taxed = $sale['igv'];
            $title_ticket = "OP.GRAVADAS";
        }


        $document = array(
            "empresa" => $company,
//            "sucursal" => $sucursal[0],
            "venta" => $sale,
            "cliente" => $client,
            "movimiento" => $movement,
            "voucher" => $voucher,
            "totales" => array(
                "total_sale" => $sale['subtotal'],
                "total_exportation" => "0.00",
                "total_free" => "0.00",
                "total_unaffected" => "0.00",
                "total_exonerated" => $total_exonerada,
                "total_gravada" => $total_gravada,
                "total_taxed" => $total_taxed,
                "total_paid" => $sale['total'],
                "title_ticket" => $title_ticket
            ),
            "orden_compra" => '',
            "items" => $detail,
            "count_items" => count($detail)
        );


        $parameter = 'a4';
        $config_branch = $this->rBranchConfig->findByBranchoffice();
        if ($voucher['id'] == config('app.voucher_factura_id')) {
            $parameter = $config_branch['print_factura'];
        }

        if ($voucher['id'] == config('app.voucher_boleta_id')) {
            $parameter = $config_branch['print_boleta'];
        }

        if ($voucher['id'] == config('app.voucher_nota_pedido_id')) {
            $parameter = $config_branch['print_boleta'];
        }

        if ($send_email) {
            return $this->designPdfA4($document, true);
        } else {
            if ($parameter == 'a5') {
                $this->designPdf5($document);
            } else if ($parameter == 'ticket') {

                if ($this->tenant->database() == config('app.database_joyeriangel')) {
                    $this->designTicketCbxPrinter($document);

                    // store MOTOREPUESTOS PALMEIRA
                } else if ($this->tenant->database() == "9CCd54Qs5F") {
                    $this->designTicketCbxPrinter($document);
                } else {
                    $this->designTicket($document);
                }
//               return $this->ticketVersion($document);

            } else {
                $this->designPdfA4($document);
            }
        }
    }

    public function printCommand($sale_id, $send_email = false)
    {

        $company = $this->tenant->company();
        $sale = $this->rOrder->find($sale_id);
        $detail = $this->rOrderDetail->findByOrderIdJoined($sale['id']);

        // delivery data
        $delivery_data = array();
        if ($sale->is_delivered) {
            $rDelivery = new SaleDeliveryRepository();
            $delivery_data = $rDelivery->find($sale->delivery_id);
        }

        // CUSTOM TOTALES
        $total_exonerada = $sale['subtotal'];
        $total_taxed = "0.00";
        $total_gravada = "0.00";
        $title_ticket = "OP.EXONERADAS";

        if ($company->typebilling_id == config('app.billing_gravada')) {
            $total_exonerada = '0.00';
            $total_gravada =  $sale['subtotal'];
            $total_taxed = $sale['igv'];
            $title_ticket = "OP.GRAVADAS";
        }

        $document = array(
            "empresa" => $company,
//            "sucursal" => $sucursal[0],
            "venta" => $sale,
            "totales" => array(
                "total_sale" => $sale['subtotal'],
                "total_exportation" => "0.00",
                "total_free" => "0.00",
                "total_unaffected" => "0.00",
                "total_exonerated" => $total_exonerada,
                "total_gravada" => $total_gravada,
                "total_taxed" => $total_taxed,
                "total_paid" => $sale['total'],
                "title_ticket" => $title_ticket
            ),
            "orden_compra" => '',
            "items" => $detail,
            "count_items" => count($detail)
        );


        $data = $document;

        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $items = count($data['items']);
        $detail = $data['items'];

        $pdf = new \App\Libraries\Pdf();
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        $ancho_celda_datos = 3.8;
        $h_header = 3;
        $h_logo = 20;
        $h_qr = 30;

        $alto = $this->getCommandStructure($data, $h_header, $h_logo, $ancho_celda_datos, $h_qr, $delivery_data);

        $ancho = 73;
        $espac = 5;

        $margin_side = 2;
        $pdf->SetAutoPageBreak(false);
        $pdf->AddPage('P', array($ancho, $alto));
        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetFillColor(255, 255, 255);

        $pdf->SetFont('Helvetica', 'B', 9);
        $pdf->SetY($espac);
        $pdf->SetX(0);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode("N° COMANDA"), 0, 0, 'C', 1);
        $espac = $espac + $h_header + 1;

        $pdf->SetY($espac);
        $pdf->SetX(0);
        $pdf->Cell($ancho, $h_header, utf8_decode($sale->code), 0, 0, 'C', 1);
        $espac = $espac + $ancho_celda_datos + 3;

        $pdf->SetY($espac);
        $pdf->SetX(0);

        //DATOS DE EMISION DE LA VENTA
        $pdf->SetFont('Helvetica', '', 7);
        $fecha = date("d/m/Y", strtotime($sale['date_order']));
        $hora = date("H:i:s", strtotime($sale['date_order']));

        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('Fecha: ' . $fecha . ' -- ' . $hora), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;

        if($sale->is_delivered){

            $pdf->SetFont('Helvetica', 'B', 7);
            $pdf->SetY($espac);
            $pdf->SetHeight(6);
            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(100));
            $pdf->Row(array("COMANDA DELIVERY"),array("L"),"N", "Y");

            $pdf->SetFont('Helvetica', '', 6);
            $pdf->SetHeight(3.3);
            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(8, 60));
            $text_delivery = $delivery_data->description."\nTEL: ".$delivery_data->cellphone."\nDIR: ".$delivery_data->address."\nFECHA: ".$delivery_data->delivery_date."   -   HORA: ".$delivery_data->delivery_time;
            $pdf->Row(array("REF:", $text_delivery),array("L"),"N", "Y");

            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(8, 60));
            $pdf->Row(array("OBS:", $delivery_data->observation),array("L"),"N", "Y");

            $pdf->SetFont('Helvetica', '', 7);
        }
        else{

            $pdf->SetY($espac);
            $pdf->SetHeight(5);
            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(100));
            $pdf->Row(array(utf8_decode('N° Mesa: ' . $sale['number_table'])),array("L"),"N", "Y");

        }

        $pdf->SetHeight(6);
        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetX($margin_side);
        $pdf->SetWidths(array(100));
        $pdf->Row(array(utf8_decode("N° DE ITEMS: "). count($detail)),array("L"),"N", "Y");

//        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('N° DE ITEMS: ' . count($detail)), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;

        $espac = $espac + 1;

        $espac = $espac + 1;
        $sbtotal = 0;
        $sumaIgv = 0;


        // detail columns
        $cols_detail = $this->get_columns_detail_ticket();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $pdf->SetFont('Arial', 'B', 5);
        $pdf->SetFillColor(245, 245, 245);
//        $pdf->SetY($espac);
        $pdf->SetX(2);
        $pdf->SetHeight(5);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(4);
        $pdf->SetFont('Arial', 'B', 5);
        $pdf->SetFillColor(255, 255, 255);

        if ($venta['is_grouped'] == true) {
            $row_grouped = array(
                'quantity' => 1,
                'unit' => 'NIU',
                'description' => $venta['description_grouped'],
                'price' => $venta['total'],
                'total' => $venta['total']
            );

            foreach ($rows as $row) {
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $sbtotal = $sbtotal + $subtotal;
            }

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row_grouped{$field}) ? utf8_decode($row_grouped{$field}) : "";
            }

            $pdf->SetX(2);
            $pdf->Row($values, $cols_pos, "Y", "Y");

            $aditional = 0;
            if (strlen($row_grouped['description']) > 25) {
                $divider = strlen($row_grouped['description']) / 25;
                $aditional = round($divider) + 20;
            }

            $espac = $espac + $pdf->GetHeight() + $aditional;
        } else {
            foreach ($rows as $row) {
                $pdf->SetX(2);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if($row['igv'] != null){
                    $subtotal = ($row['price'] * $row['quantity']) + $row['igv'] ;
                }

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                // CUSTOM DESCRIPTION
                $row['description'] = $product['description'];

                if($row['typeprice_id'] == config('app.catalog_price_variant')){
                    $variant = $this->rProductVariant->find($row['productvariant_id']);
                    $row['description'] = $row['description']."\n".$variant['type'];
                }

                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $values = array();
                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $sbtotal = $sbtotal + $subtotal;
//                $pdf->Row($values, $cols_pos, "Y", "Y");

                $pdf->SetFont('Arial', 'B', 5.5);
                $pdf->SetHeight(3.5);
                $pdf->SetWidths(array(22,10,7,14,15));
                $pdf->Row(array($product->code, $row['quantity'],$row['unit'],$row['price'], $row['total']),array("L", "C", "C" ,"C", "R"), "N", "Y");

                $pdf->SetFont('Arial', '', 5);
                $pdf->SetX(2);
                $pdf->SetHeight(3);
                $pdf->SetWidths(array(60));
                $pdf->Row(array(utf8_decode($row['description'])),array("L"),"N", "Y");

                $pdf->SetX(2);
                $pdf->SetHeight(1.2);
                $pdf->SetWidths(array(68));
                $pdf->Row(array(utf8_decode("......................................................................................................................................")),array("L"), "N", "Y");


                $aditional = 0;
                if (strlen($row->description) > 25) {
                    $divider = strlen($row->description) / 25;
                    $aditional = round($divider) + 2;
                }

//                $espac = $espac + $pdf->GetHeight() + $aditional;

                $espac = $espac + 7.7 + $aditional;
            }
        }



        // RESUMEN DE VENTA
        $pdf->SetFont('Arial', 'B', 7);

        $pdf->SetHeight(5);
        $pdf->SetX(31);
        $pdf->SetWidths(array(25,15));
        $pdf->Row(array(utf8_decode($data['totales']['title_ticket']), utf8_decode('S/ ' . number_format($data['totales']['total_sale'], 2))),array("L","R"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX(31);
        $pdf->SetWidths(array(25,15));
        $pdf->Row(array(utf8_decode("IGV"), utf8_decode('S/ ' . number_format($data['totales']['total_taxed'], 2))),array("L","R"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX(31);
        $pdf->SetWidths(array(25,15));
        $pdf->Row(array(utf8_decode("TOTAL PAGAR"), utf8_decode('S/ ' . number_format($data['totales']['total_paid'], 2))),array("L","R"),"N", "Y");

        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetHeight(6);
        $pdf->SetX(2);
        $pdf->SetWidths(array(8,65));
        $pdf->Row(array(utf8_decode("SON :"), utf8_decode($sale['text_amount'])),array("L","L"),"N", "Y");

        $pdf->AutoPrint();
        $pdf->output();
        exit;


    }

    public function designPdfA4($data, $send_email = false)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $cliente = $data['cliente'];
        $movimiento = $data['movimiento'];
        $voucher = $data['voucher'];
        $items = count($data['items']);
        $detail = $data['items'];

        $pdf = new \App\Libraries\Pdf();

        $pdf->AliasNbPages(); // para el conteo de paginas
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        // espacios iniciales
        $ancho_total = 210;
        $height_total = 297;
        $espac = 5;
        $pos_initial_x = 5;
        $separetor_coluns = 5;
        $h_row = 3.5;
        $h_logo = 27;
        $w_logo = 47;

        $pdf->AddPage('P', 'A4');
//        $pdf->AddPage('P', array($ancho_total, $height_total));

        // CUADRADO TOTAL DE LA PAGINA
        $pdf->SetFillColor(255, 255, 255);
        $pdf->RoundedRect($pos_initial_x, $espac, $ancho_total - ($pos_initial_x + $espac), $height_total - ($pos_initial_x + $espac), 2, '1234', 'S');

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa['url_image'];
        }

        $pdf->Image($logo_empresa, $pos_initial_x + 3, $espac + 3, $w_logo, $h_logo);

        $initial_head = 15;
        $w_head = 80;


        $txt_razon_empresa = $empresa['social_reason'];
        $txt_tradename = $empresa->tradename;

        if ($txt_tradename != null or $txt_tradename != '') {

            $pdf->SetFont('Arial', 'B', 11);
            $pdf->SetY($initial_head - 5);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_tradename), 0);

            if (strlen($txt_razon_empresa) > 28) {
                $initial_head = $initial_head + $h_row - 0.5;
            }

            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(1.1 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->Cell($w_head, $h_row, utf8_decode($txt_razon_empresa), 0, 0, 'L', 1);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetY(1.4 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

            $txt_address = strtoupper(utf8_decode($empresa['address'])) . "\nTEL: " . $empresa['cellphone'] . " - " . $empresa['telephone'] . "\n" . $empresa['email'];

            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(1.7 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        } else {
            $pdf->SetFont('Arial', '', 10);
            $pdf->SetY($initial_head - 5);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_razon_empresa), 0);

            if (strlen($txt_razon_empresa) > 28) {
                $initial_head = $initial_head + $h_row - 0.5;
            }

            $pdf->SetFont('Arial', 'B', 11);
            $pdf->SetY(1.1 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

            $txt_address = strtoupper(utf8_decode($empresa['address'])) . "\nTEL: " . $empresa['cellphone'] . " - " . $empresa['telephone'] . "\n" . $empresa['email'];

            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(1.5 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        }

        // cuadradito para numero de factura
        $pdf->SetFillColor(245, 245, 245);
        $position_invoice_square = $pos_initial_x + $w_logo + $separetor_coluns + $w_head + $separetor_coluns;
        $w_invoice_square = $ancho_total - $position_invoice_square - 10;
        $pdf->RoundedRect($position_invoice_square, $espac + 7.5, $w_invoice_square, 25, 2, '1234', 'FD');

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($espac + 14);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($voucher['description']), 0, 0, 'C', 1);

        $pdf->SetFont('Arial', 'B', 16);
        $pdf->SetY($espac + 23);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);


        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetFont('Arial', '', 9);
        $espac = $espac + $initial_head + 25;
        $fecha = date("d/m/Y", strtotime($movimiento['date_movement']));
        $hora = date("H:i:s", strtotime($movimiento['date_movement']));

        $side_r = 5;
        $w_initial = 20;
        $w_final = 125;
        $pos_x_h = $pos_initial_x + $side_r;
        $separador_row = 2;
        $space_temp = $espac;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Emisión'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $fecha . '  -  ' . $hora), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

//        $pdf->SetY($space_temp);
//        $pdf->SetX($pos_x_h);
//        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Vencimiento'), 0, 0, 'L', 1);
//        $pdf->SetY($space_temp);
//        $pdf->SetX($pos_x_h + $w_initial + $side_r);
//        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $fecha), 0, 0, 'L', 1);
//
//        $space_temp = $space_temp + $h_row + $separador_row;

        $label_comprobante = $cliente->typeDocument;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode($label_comprobante), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['document']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Cliente'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['fullname']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Dirección'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $cliente['address']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        //**
        //TODO: REORGANIZAR CODIGO  CUANDO TODAS LAS MIGRACIONES TENGAN EL CAMPO "OBSERVATION"
        $space_table_detail = 75;
        if (isset($venta['observation'])) {
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Observaciones'), 0, 0, 'L', 1);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $venta['observation']), 0);

            $space_table_detail = 80;
        }
        //**

        $w_initial = $w_initial + 5;

        $pos_x_h = $pos_initial_x + $side_r + $w_final + $side_r;
        $w_final_col = $ancho_total - ($pos_x_h + $w_initial + $side_r) - 10;

        $space_temp = $espac;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Condición pago'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($venta['typetransaction'])), 0, 0, 'L', 1);
//        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description'])), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;


        if($venta['typetransaction_id'] == config('app.transaction_cash')){
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Medio Pago'), 0, 0, 'L', 1);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description'])), 0, 0, 'L', 1);

            $space_temp = $space_temp + $h_row + $separador_row;
        }else{

            $schedule = $this->rScheduleSale->findBySale($venta['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);

            //  N° cuotas credito

            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('N° de cuotas'), 0, 0, 'L', 1);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . count($schedule_detail)), 0, 0, 'L', 1);

            $space_temp = $space_temp + $h_row + $separador_row;

            //  fecha venciemiento credito

            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Fecha Venc. Credi'), 0, 0, 'L', 1);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $schedule_detail[0]['date_assigned']), 0, 0, 'L', 1);

            $space_temp = $space_temp + $h_row + $separador_row;
        }

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('N° guía remisión'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': -'), 0, 0, 'L', 1);

        $espac = $espac + 2;
        $sbtotal = 0;
        $sumaIgv = 0;

        $code_leyenda = config('app.code_leyenda_bienes_exonerado');
        $txt_leyenda = config('app.txt_leyenda_bienes_exonerado');

        // detail columns
        $cols_detail = $this->get_columns_detail_a4();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetFillColor(245, 245, 245);
        $pdf->SetY($space_table_detail);
        $pdf->SetX($pos_initial_x);
        $pdf->SetHeight(7);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(5);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetFillColor(255, 255, 255);

        if ($venta['is_grouped'] == true) {

            $row_grouped = array(
                'quantity' => 1,
                'unit' => 'NIU',
                'description' => $venta['description_grouped'],
                'price' => $venta['total'],
                'total' => $venta['total']
            );

            foreach ($rows as $row) {
                $pdf->SetX($pos_initial_x);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $sbtotal = $sbtotal + $subtotal;
            }

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row_grouped{$field}) ? utf8_decode($row_grouped{$field}) : "";
            }

            $pdf->Row($values, $cols_pos, "Y", "Y");
        } else {
            foreach ($rows as $row) {
                $pdf->SetX($pos_initial_x);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if($row['igv'] != null){
                    $subtotal = ($row['price'] * $row['quantity']) + $row['igv'] ;
                }

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $values = array();
                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $sbtotal = $sbtotal + $subtotal;
                $pdf->Row($values, $cols_pos, "Y", "Y");
            }
        }


        $dataImg = array(
            $empresa['ruc'],
            $movimiento['voucher_id'],
            $movimiento['serie'],
            $movimiento['correlative'],
            $venta['total'],
            date('Y-m-d', strtotime($venta['date_sale'])),
            $cliente['typedocument_id'],
            $cliente['document'],
            ""
        );

        $pdf->SetAutoPageBreak(false);

        $initial_footer = 240;

        $pos_qr_y = $initial_footer;
        $w_qr = 40;
        $w_txt_qr = 80;


        $pdf->Line($pos_initial_x, $initial_footer - 10, $ancho_total - $side_r, $initial_footer - 10); // 20mm from each edge


        $pdf->SetFont('Arial', 'B', 7);
        $pdf->SetY($initial_footer - 7);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Son : " . $movimiento['text_amount']), 0);

        $fileTmp = "archivos/" . $empresa['ruc'] . "-" . $movimiento['voucher_id'] . "-" . $movimiento['nro_voucher'] . ".png";

        QrCode::format('png')->size(1)->margin(0)->generate(implode("|", $dataImg), $fileTmp, QR_ECLEVEL_Q, 2, 1);

        if (file_exists($fileTmp)) {
            $imagen_qr_encode = base64_encode(file_get_contents($fileTmp));
            $pic = 'data://text/plain;base64,' . $imagen_qr_encode;
            $info = getimagesize($pic);
            unlink($fileTmp);
            $pdf->Image($pic, $pos_initial_x + $side_r, $pos_qr_y, $w_qr, $height_total - $pos_qr_y - 21, 'png');
        }

        $pdf->SetFont('Arial', '', 6);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 22) + 3);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row + 1, utf8_decode($code_leyenda . ': ' . $txt_leyenda), 0);


        // text empresa

        $pdf->SetFont('Arial', 'B', 7.5);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 18) + 3);
        $pdf->SetX($pos_initial_x + $side_r+20);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row + 1, utf8_decode('Sistema diseñado y desarrollado por Informatica Perú'), 0);

        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 14) + 3);
        $pdf->SetX($pos_initial_x + $side_r+15);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row + 1, utf8_decode('www.informaticaperu.pe'), 0);

        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 14) + 3);
        $pdf->SetX($pos_initial_x + $side_r+50);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row + 1, utf8_decode('Contacto : 916 898 981 - 915 334 771'), 0);

        // =================


        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y + 2);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode('Código Hash: ' . $movimiento['billing_hash']), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 8;

        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode("Representación impresa de"), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 1;

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode($voucher['description']), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 5;

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode("Para consultar el comprobante ingresar a:"), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 1;

        $pdf->SetFont('Arial', 'B', 9);

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode($empresa['api_facturador'] . '/buscar'), 0, 0, 'L', 1);

        $pdf->Line($w_txt_qr + $w_qr + $side_r, $initial_footer - 10, $w_txt_qr + $w_qr + $side_r, $height_total - 5); // 20mm from each edge


        $w_summary_label = 40;
        $separetor_summary = 7;
        $initial_summary = $initial_footer - 2.5;

        $pdf->SetFont('Arial', 'B', 8);

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("TOTAL VALOR DE VENTA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_sale'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

//        $pdf->SetY($initial_summary);
//        $pdf->SetX($w_txt_qr+ $w_qr+2*$side_r);
//        $pdf->Cell($w_summary_label,$h_row,utf8_decode("TOTAL DESCUENTO"),0,0,'R',1);
//        $pdf->SetX($ancho_total-$w_summary_label);
//        $pdf->Cell($ancho_total-($w_txt_qr+ $w_qr+ 2*$side_r+$w_summary_label+2*$side_r),$h_row,utf8_decode('S/ 0.00'),0,0,'R',1);
//
//        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN EXONERADA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_exonerated'], 2)), 0, 0, 'R', 1);
        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN GRAVADA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row,  utf8_decode('S/ ' . number_format($data['totales']['total_gravada'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN INAFECTA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_unaffected'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN GRATUITA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_free'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IGV"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_taxed'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary + 2.5;

        $total = $sbtotal + ($sumaIgv);

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("TOTAL A PAGAR"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_paid'], 2)), 0, 0, 'R', 1);

        if ($send_email == true) {
            $response = array(
                'pdf' => $pdf,
                'billing' => $movimiento,
            );

            return $response;
        } else {
            $pdf->Output();
        }

    }

    public function designPdf5($data)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $cliente = $data['cliente'];
        $movimiento = $data['movimiento'];
        $voucher = $data['voucher'];
        $items = count($data['items']);
        $detail = $data['items'];

        $pdf = new \App\Libraries\Pdf();
        $pdf->AliasNbPages(); // para el conteo de paginas
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        // espacios iniciales
        $ancho_total = 210;
        $height_total = 148;
        $espac = 3;
        $pos_initial_x = 3;
        $separetor_coluns = 5;
        $h_row = 3.1;
        $h_logo = 20;
        $w_logo = 33;

        $pdf->AddPage('L', 'A5', 0, 1);

        // CUADRADO TOTAL DE LA PAGINA
        $pdf->SetFillColor(255, 255, 255);

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa->url_image;
        }

        $pdf->Image($logo_empresa, $pos_initial_x + 3, $espac + 2, $w_logo, $h_logo);

        $initial_head = 5;
        $w_head = 112;


        $txt_tradename = $empresa->tradename;
        $txt_razon_empresa = $empresa->social_reason;


        if ($txt_tradename != null or $txt_tradename != '') {
            $pdf->SetFont('Arial', 'B', 10);
            $pdf->SetY($initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->MultiCell($w_head, $h_row + 1.7, utf8_decode($txt_tradename), 0);

            if (strlen($txt_tradename) > 28) {
                $initial_head = $initial_head + $h_row - 0.5;
            } else {
                $initial_head = $initial_head + $h_row - 1;
            }

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(1.4 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->Cell($w_head, $h_row, utf8_decode($txt_razon_empresa), 0, 0, 'L', 1);

            $pdf->SetFont('Arial', 'B', 8);
            $pdf->SetY(2 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->Cell($w_head, $h_row, utf8_decode('RUC:  ' . $empresa['ruc']), 0, 0, 'L', 1);

            $txt_address = strtoupper(utf8_decode($empresa['address'])) . "\nTEL: " . $empresa['cellphone'] . " - " . $empresa['telephone'] . "   -   " . $empresa['email'];

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(2.5 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);


        } else {

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY($initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_razon_empresa), 0);

            if (strlen($txt_razon_empresa) > 28) {
                $initial_head = $initial_head + $h_row - 0.5;
            }

            $pdf->SetFont('Arial', 'B', 10);
            $pdf->SetY(2.1 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

            $txt_address = strtoupper(utf8_decode($empresa['address'])) . "\nTEL: " . $empresa['cellphone'] . " - " . $empresa['telephone'] . "   -   " . $empresa['email'];

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(3 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
            $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);
        }


        // cuadradito para numero de factura
        $pdf->SetFillColor(245, 245, 245);
        $position_invoice_square = $pos_initial_x + $w_logo + $separetor_coluns + $w_head + $separetor_coluns;
        $w_invoice_square = $ancho_total - $position_invoice_square - 6;
        $pdf->RoundedRect($position_invoice_square, $espac + 1, $w_invoice_square, 17.5, 2, '1234', 'FD');

        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetY($espac + 5);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($voucher['description']), 0, 0, 'C', 1);

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($espac + 12);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);


        $pdf->SetFillColor(255, 255, 255);
        $espac = $espac + $initial_head + 25;
        $fecha = date("d/m/Y", strtotime($movimiento['date_movement']));
        $hora = date("H:i:s", strtotime($movimiento['date_movement']));

        $side_r = 2;
        $w_initial = 20;
        $w_final = 140;
        $pos_x_h = $pos_initial_x + $side_r;
        $separador_row = 2;
        $space_temp = $espac - 5;
        $h_row = 2.5;

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Emisión'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $fecha . '  -  ' . $hora), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

//        $pdf->SetFont('Arial', 'B', 8);
//        $pdf->SetY($space_temp);
//        $pdf->SetX($pos_x_h);
//        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Vencimiento'), 0, 0, 'L', 1);
//        $pdf->SetFont('Arial', '', 8);
//        $pdf->SetY($space_temp);
//        $pdf->SetX($pos_x_h + $w_initial + $side_r);
//        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $fecha), 0, 0, 'L', 1);
//
//        $space_temp = $space_temp + $h_row + $separador_row;

        $label_comprobante = $cliente->typeDocument;
//        $label_comprobante = "RUC";
//        if ($movimiento->voucher_id == config('app.voucher_boleta_id')) {
//            $label_comprobante = "DNI";
//        }

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode($label_comprobante), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['document']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Cliente'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['fullname']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Dirección'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $cliente['address']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;


        //**
        //TODO: REORGANIZAR CODIGO  CUANDO TODAS LAS MIGRACIONES TENGAN EL CAMPO "OBSERVATION"
        $space_table_detail = 17;
        if (isset($venta['observation'])) {
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Observaciones'), 0, 0, 'L', 1);
            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $venta['observation']), 0);
            $space_table_detail = 22;
        }
        //**

        $w_initial = $w_initial + 5;

        $pos_x_h = $pos_initial_x + $side_r + $w_final + $side_r;
        $w_final_col = $ancho_total - ($pos_x_h + $w_initial + $side_r) - 10;

        $space_temp = $espac - 5;

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Condición pago'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($venta['typetransaction'])), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;


        if($venta['typetransaction_id'] == config('app.transaction_cash')){
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Medio pago'), 0, 0, 'L', 1);
            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description'])), 0, 0, 'L', 1);

            $space_temp = $space_temp + $h_row + $separador_row;

        }else{

            $schedule = $this->rScheduleSale->findBySale($venta['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);

            //  N° cuotas credito ========

            $pdf->SetFont('Arial', 'B', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('N° de cuotas'), 0, 0, 'L', 1);
            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . count($schedule_detail)), 0, 0, 'L', 1);

            $space_temp = $space_temp + $h_row + $separador_row;

            //  fecha venciemiento credito

            $pdf->SetFont('Arial', 'B', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Fecha Venc. Credi'), 0, 0, 'L', 1);
            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $schedule_detail[0]['date_assigned']), 0, 0, 'L', 1);

            $space_temp = $space_temp + $h_row + $separador_row;


        }


        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('N° guía remisión'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': -'), 0, 0, 'L', 1);

        $espac = $espac + 2;
        $sbtotal = 0;
        $sumaIgv = 0;

        $code_leyenda = config('app.code_leyenda_bienes_exonerado');
        $txt_leyenda = config('app.txt_leyenda_bienes_exonerado');

        // detail columns
        $cols_detail = $this->get_columns_detail_a4();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetFillColor(245, 245, 245);
        $pdf->SetY($espac + $space_table_detail);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->SetHeight(7);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(5);
        $pdf->SetFont('Arial', '', 7);
        $pdf->SetFillColor(255, 255, 255);

        if ($venta['is_grouped'] == true) {
            $row_grouped = array(
                'quantity' => 1,
                'unit' => 'NIU',
                'description' => $venta['description_grouped'],
                'price' => $venta['total'],
                'total' => $venta['total']
            );

            foreach ($rows as $row) {
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $sbtotal = $sbtotal + $subtotal;
            }

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row_grouped{$field}) ? utf8_decode($row_grouped{$field}) : "";
            }

            $pdf->SetX($pos_initial_x + $side_r);
            $pdf->Row($values, $cols_pos, "Y", "Y");
        } else {
            foreach ($rows as $row) {
                $pdf->SetX($pos_initial_x + $side_r);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];
                if($row['igv'] != null){
                    $subtotal = ($row['price'] * $row['quantity']) + $row['igv'] ;
                }

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $values = array();
                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $sbtotal = $sbtotal + $subtotal;
                $pdf->Row($values, $cols_pos, "Y", "Y");
            }
        }


        $dataImg = array(
            $empresa['ruc'],
            $movimiento['voucher_id'],
            $movimiento['serie'],
            $movimiento['correlative'],
            $venta['total'],
            date('Y-m-d', strtotime($venta['date_sale'])),
            $cliente['typedocument_id'],
            $cliente['document'],
            ""
        );

        $pdf->SetAutoPageBreak(false);

        $initial_footer = 120;

        $pos_qr_y = $initial_footer - 2;
        $w_qr = 25;
        $w_txt_qr = 100;


        $pdf->Line($pos_initial_x, $initial_footer - 10, $ancho_total - $side_r, $initial_footer - 10); // 20mm from each edge


        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetY($initial_footer - 7);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Son : " . $movimiento['text_amount']), 0);

        $fileTmp = "archivos/" . $empresa['ruc'] . "-" . $movimiento['voucher_id'] . "-" . $movimiento['nro_voucher'] . ".png";

        QrCode::format('png')->size(1)->margin(0)->generate(implode("|", $dataImg), $fileTmp, QR_ECLEVEL_Q, 2, 1);

        if (file_exists($fileTmp)) {
            $imagen_qr_encode = base64_encode(file_get_contents($fileTmp));
            $pic = 'data://text/plain;base64,' . $imagen_qr_encode;
            $info = getimagesize($pic);
            unlink($fileTmp);
            $pdf->Image($pic, $pos_initial_x + $side_r, $pos_qr_y, $w_qr, $height_total - $pos_qr_y - 10, 'png');
        }

        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 8));
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row + 1, utf8_decode($code_leyenda . ': ' . $txt_leyenda), 0);


        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y + 1);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode('Código Hash: ' . $movimiento['billing_hash']), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 3;

        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode("Representación impresa de"), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 1;

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode($voucher['description']), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 2;

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode("Para consultar el comprobante ingresar a:"), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 1;

        $pdf->SetFont('Arial', 'B', 7);

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode($empresa['api_facturador'] . '/buscar'), 0, 0, 'L', 1);

        $pdf->Line($w_txt_qr + $w_qr + $side_r, $initial_footer - 10, $w_txt_qr + $w_qr + $side_r, $height_total - 5); // 20mm from each edge

        $w_summary_label = 40;
        $separetor_summary = 4.7;
        $initial_summary = $initial_footer - 6.5;

        $pdf->SetFont('Arial', 'B', 7);

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("TOTAL VALOR DE VENTA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_sale'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN EXONERADA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_exonerated'], 2)), 0, 0, 'R', 1);
        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN GRAVADA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_gravada'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN INAFECTA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_unaffected'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN GRATUITA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_free'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IGV"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_taxed'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary + 0.5;

        $total = $sbtotal + ($sumaIgv);

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("TOTAL A PAGAR"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_paid'], 2)), 0, 0, 'R', 1);

        $pdf->Output();

    }

    public function designTicketCbxPrinter($data)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $cliente = $data['cliente'];
        $movimiento = $data['movimiento'];
        $voucher = $data['voucher'];
        $items = count($data['items']);
        $detail = $data['items'];

        $pdf = new \App\Libraries\Pdf();
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        $ancho_celda_datos = 3.8;
        $h_header = 3;
        $h_logo = 20;
        $h_qr = 35;

        $alto = $this->getTicketStructure($data, $h_header, $h_logo, $ancho_celda_datos, $h_qr);

        $ancho = 80;
        $espac = 1.5;

        $margin_side = 3;
        $pdf->SetAutoPageBreak(false);
        $pdf->AddPage('P', array($ancho, $alto));
        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetFillColor(255, 255, 255);

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa->url_image;
        }

        $pdf->Image($logo_empresa, 18, $espac, $ancho - 35, $h_logo);
        $espac = $espac + $h_header + $h_logo;

        $txt_tradename = $empresa->tradename;

        if ($txt_tradename != null or $txt_tradename != '') {

            $pdf->SetFont('Helvetica', 'B', 8);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($empresa->tradename), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 7);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($empresa->social_reason), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 8);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode('RUC  ' . $empresa->ruc), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 7);

            $address = strtoupper($empresa->address);
            $h_address = 3;
            if (strlen($address) > 40) {
                $h_address = 5;
            }

            $pdf->SetY($espac);
            $pdf->SetX(3);
            $pdf->MultiCell($ancho - 5, 3, utf8_decode($address), 0, "C");
            $espac = $espac + $h_header + $h_address;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('TEL: ' . $empresa->telephone . ' - ' . $empresa->cellphone . ' / ' . $empresa->email), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 3;

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode($voucher['description']), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);
            $espac = $espac + $ancho_celda_datos + 3;

            $pdf->SetY($espac);
            $pdf->SetX(0);

        }
        else {

            $pdf->SetFont('Helvetica', 'B', 7);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($empresa->social_reason), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', 'B', 8);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode('RUC  ' . $empresa->ruc), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 7);

            $address = strtoupper($empresa->address);
            $h_address = 3;
            if (strlen($address) > 40) {
                $h_address = 5;
            }

            $pdf->SetY($espac);
            $pdf->SetX(3);
            $pdf->MultiCell($ancho - 5, 3, utf8_decode($address), 0, "C");
            $espac = $espac + $h_header + $h_address;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('TEL: ' . $empresa->telephone . ' - ' . $empresa->cellphone . ' / ' . $empresa->email), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 3;

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode($voucher['description']), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);
            $espac = $espac + $ancho_celda_datos + 3;

            $pdf->SetY($espac);
            $pdf->SetX(0);

        }


        //$pdf->Cell($ancho,$ancho_celda_datos,utf8_decode('Nº AUTORIZACIÓN: 0183845129037'),0,0,'C',1);


        //DATOS DE EMISION DE LA VENTA
        $pdf->SetFont('Helvetica', '', 7.5);
        $fecha = date("d/m/Y", strtotime($movimiento['date_movement']));
        $hora = date("H:i:s", strtotime($movimiento['date_movement']));

        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('F. Emisión: ' . $fecha . ' -- ' . $hora), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;

        // $pdf->SetY($espac);
        // $pdf->SetX($margin_side);
        // $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('F. Vcto.     : ' . $fecha), 0, 0, 'L', 1);
        // $espac = $espac + $ancho_celda_datos;

        if ($venta['typetransaction_id'] == config('app.transaction_credit')) {
            $schedule = $this->rScheduleSale->findBySale($venta['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);
            
            $pdf->SetY($espac);
            $pdf->SetX($margin_side);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('F. Vcto.     : ' .$schedule_detail->last()->date_assigned), 0, 0, 'L', 1);
            $espac = $espac + $ancho_celda_datos;
        }

        $label_comprobante = $cliente->typeDocument;

        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode($label_comprobante), 0, 36), 0, 0, 'L', 1);
        $pdf->SetX(15);
        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode($cliente['document']), 0, 36), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;


        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('Cliente:'), 0, 0, 'L', 1);
        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetX(15);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode($cliente['fullname']), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;

        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode('Dirección:'), 0, 36), 0, 0, 'L', 1);
        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetX(15);
//        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode($cliente['address']), 0, 36), 0, 0, 'L', 1);
        $pdf->MultiCell($ancho - 20, 3, utf8_decode($cliente['address']), 0);


        $espac = $espac + $ancho_celda_datos;

        //**
        //TODO: REORGANIZAR CODIGO  CUANDO TODAS LAS MIGRACIONES TENGAN EL CAMPO "OBSERVATION"
        if (isset($venta['observation'])) {
            $pdf->SetFont('Helvetica', '', 7);
            $pdf->SetY($espac);
            $pdf->SetX(2);
            $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode('Obs.:'), 0, 36), 0, 0, 'L', 1);
            $pdf->SetFont('Helvetica', '', 6);
            $pdf->SetX(15);
            $pdf->MultiCell($ancho - 20, 3, utf8_decode($venta['observation']), 0);
        }
        //**

        $espac = $espac + $ancho_celda_datos + 2;

        $espac = $espac + 1 - 3;
        $sbtotal = 0;
        $sumaIgv = 0;

        $code_leyenda = config('app.code_leyenda_bienes_exonerado');
        $txt_leyenda = config('app.txt_leyenda_bienes_exonerado');


        // detail columns
        $cols_detail = $this->get_columns_detail_ticket_cbx();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $val_fill_row_tbl_header = 185;
        $pdf->SetFont('Arial', 'B', 7.5);
        $pdf->SetFillColor($val_fill_row_tbl_header, $val_fill_row_tbl_header, $val_fill_row_tbl_header);
        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->SetHeight(6.5);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array($val_fill_row_tbl_header, $val_fill_row_tbl_header, $val_fill_row_tbl_header));

        $pdf->SetHeight(4);
        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetFillColor(255, 255, 255);

        if ($venta['is_grouped'] == true) {
            $row_grouped = array(
                'quantity' => 1,
                'unit' => 'NIU',
                'description' => $venta['description_grouped'],
                'price' => $venta['total'],
                'total' => $venta['total']
            );

            foreach ($rows as $row) {
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $sbtotal = $sbtotal + $subtotal;
            }

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row_grouped{$field}) ? utf8_decode($row_grouped{$field}) : "";
            }

            $pdf->SetX(2);
            $pdf->Row($values, $cols_pos, "Y", "Y");

            $aditional = 0;
            if (strlen($row_grouped['description']) > 25) {
                $divider = strlen($row_grouped['description']) / 25;
                $aditional = round($divider) + 20;
            }

            $espac = $espac + $pdf->GetHeight() + $aditional;
        } else {
            foreach ($rows as $row) {
                $pdf->SetX($margin_side);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if($row['igv'] != null){
                    $subtotal = ($row['price'] * $row['quantity']) + $row['igv'] ;
                }

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                // CUSTOM DESCRIPTION
                $row['description'] = $product['description'];

                if($product['typeprice_id'] == config('app.catalog_price_variant')){
                    $variant = $this->rProductVariant->find($row['productvariant_id']);
                    $row['description'] = $row['description']."\n".$variant['type'];
                }

                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $values = array();
                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $sbtotal = $sbtotal + $subtotal;

//                $pdf->Row($values, $cols_pos, "Y", "Y");

                $pdf->SetFont('Helvetica', 'B', 7);
                $pdf->SetHeight(4.5);
                $pdf->SetWidths(array(20,14,8,15,16.5));
                $pdf->Row(array($product->code, $row['quantity'],$row['unit'],$row['price'], $row['total']),array("L", "C", "C" ,"C", "R"), "N", "Y");

                $pdf->SetFont('Helvetica', '', 7);
                $pdf->SetX($margin_side);
                $pdf->SetHeight(3);
                $pdf->SetWidths(array(70));
                $pdf->Row(array(utf8_decode($row['description'])),array("L"),"N", "Y");

                $pdf->SetX($margin_side);
                $pdf->SetHeight(1.2);
                $pdf->SetWidths(array(100));
                $pdf->Row(array(utf8_decode("..........................................................................................................")),array("L"), "N", "Y");


                $aditional = 0;
                if (strlen($row->description) > 60) {
                    $divider = strlen($row->description) / 60;
                    $aditional = round($divider) + 3;
                }

//                dd($pdf->GetHeight());

                $espac = $espac + 7.7 + $aditional;
            }
        }

        $pdf->SetWidths(array(25));
        $pdf->Row(array(utf8_decode("\n .")),array("L"),"N", "Y");

        // RESUMEN DE VENTA
        $pdf->SetFont('Arial', 'B', 7);

        $side_summary = 33;

        $pdf->SetHeight(4);
        $pdf->SetX($side_summary);
        $pdf->SetWidths(array(25,18));
        $pdf->Row(array(utf8_decode($data['totales']['title_ticket']), utf8_decode('S/ ' . number_format($data['totales']['total_sale'], 2))),array("L","R"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX($side_summary);
        $pdf->SetWidths(array(25,18));
        $pdf->Row(array(utf8_decode("IGV"), utf8_decode('S/ ' . number_format($data['totales']['total_taxed'], 2))),array("L","R"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX($side_summary);
        $pdf->SetWidths(array(25,18));
        $pdf->Row(array(utf8_decode("TOTAL PAGAR"), utf8_decode('S/ ' . number_format($data['totales']['total_paid'], 2))),array("L","R"),"N", "Y");

        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetHeight(3.5);
        $pdf->SetX($margin_side);
        $pdf->SetWidths(array(8,65));
        $pdf->Row(array(utf8_decode("SON :"), utf8_decode($movimiento['text_amount'])),array("L","L"),"N", "Y");

        $pdf->SetHeight(6);
        $pdf->SetX($margin_side);
        $pdf->SetWidths(array(22,40));
        $pdf->Row(array(utf8_decode("CONDICIÓN PAGO:"), utf8_decode(strtoupper($venta['typetransaction']))),array("L","L"),"N", "Y");

        if($venta['typetransaction_id'] == config('app.transaction_cash')){

            $pdf->SetHeight(3);
            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(22,40));
            $pdf->Row(array(utf8_decode("MEDIO DE PAGO:"), utf8_decode(strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description']))),array("L","L"),"N", "Y");

        }else{

            $schedule = $this->rScheduleSale->findBySale($venta['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);

            //  N° cuotas credito
            $pdf->SetHeight(4);
            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(22,40));
            $pdf->Row(array(utf8_decode("N° DE CUOTAS :"), utf8_decode(count($schedule_detail))),array("L","L"),"N", "Y");

            //  fecha venciemiento credito
            $pdf->SetHeight(4);
            $pdf->SetX($margin_side);
            $pdf->SetWidths(array(25,40));
            $pdf->Row(array(utf8_decode("FECHA VENC. CRED. :"), utf8_decode($schedule_detail[0]['date_assigned'])),array("L","L"),"N", "Y");

            $espac  = $espac + 4;
        }


//        $espac = $espac + 15;
//        $pdf->SetY($espac);

        $pdf->SetFont('Arial', 'B', 6);

        $pdf->SetHeight(4);
        $pdf->SetX($margin_side);
        $pdf->SetWidths(array(50));
        $pdf->Row(array(utf8_decode("Leyendas :")),array("L","L"),"N", "Y");

        $pdf->SetHeight(3);
        $pdf->SetX($margin_side);
        $pdf->SetWidths(array(70));
        $pdf->Row(array(utf8_decode($code_leyenda . ': ' . $txt_leyenda)),array("L","L"),"N", "Y");


        $espac  = $espac + 50;

        $dataImg = array(
            $empresa['ruc'],
            $movimiento['voucher_id'],
            $movimiento['serie'],
            $movimiento['correlative'],
            $venta['total'],
            date('Y-m-d', strtotime($venta['date_sale'])),
            $cliente['typedocument_id'],
            $cliente['document'],
            ""
        );

        $fileTmp = "archivos/" . $empresa['ruc'] . "-" . $movimiento['voucher_id'] . "-" . $movimiento['nro_voucher'] . ".png";
        QrCode::format('png')->size(1)->margin(0)->generate(implode("|", $dataImg), $fileTmp, QR_ECLEVEL_Q, 2, 1);

        if (file_exists($fileTmp)) {
            $imagen_qr_encode = base64_encode(file_get_contents($fileTmp));
            $pic = 'data://text/plain;base64,' . $imagen_qr_encode;
            $info = getimagesize($pic);
            unlink($fileTmp);
            $pdf->Image($pic, $margin_side + 1.5, $espac, 20, 20, 'png');
        }

        $pdf->SetFont('Arial', 'B', 5.5);
        $pdf->SetY($espac);

        $pdf->SetHeight(3);
        $pdf->SetX(25);
        $pdf->SetWidths(array(48));
        $pdf->Row(array(utf8_decode("Representación impresa de la ".$voucher['description'].". Para consultar el comprobante ingresar a: \n".utf8_decode($empresa['api_facturador'] . '/buscar'))),array("L","L"),"N", "Y");

        $pdf->SetFont('Arial', 'B', 5);
        $pdf->SetHeight(3);
        $pdf->SetX(25);
        $pdf->SetWidths(array(48));
        $pdf->Row(array(utf8_decode("\n Código Hash: ".$movimiento['billing_hash'])),array("L","L"),"N", "Y");


        $pdf->AutoPrint();
        $pdf->output();
        exit;
    }

    public function designTicket($data)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $cliente = $data['cliente'];
        $movimiento = $data['movimiento'];
        $voucher = $data['voucher'];
        $items = count($data['items']);
        $detail = $data['items'];

        $pdf = new \App\Libraries\Pdf();
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        $ancho_celda_datos = 3.8;
        $h_header = 3;
        $h_logo = 20;
        $h_qr = 35;

        $alto = $this->getTicketStructure($data, $h_header, $h_logo, $ancho_celda_datos, $h_qr);

        $ancho = 73;
        $espac = 5;

        $margin_side = 2;
        $pdf->SetAutoPageBreak(false);
        $pdf->AddPage('P', array($ancho, $alto));
        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetFillColor(255, 255, 255);

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa->url_image;
        }

        $pdf->Image($logo_empresa, 15, $espac, $ancho - 30, $h_logo);
        $espac = $espac + $h_header + $h_logo;

        $txt_tradename = $empresa->tradename;

        if ($txt_tradename != null or $txt_tradename != '') {

            $pdf->SetFont('Helvetica', 'B', 8);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($empresa->tradename), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 7);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($empresa->social_reason), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 8);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode('RUC  ' . $empresa->ruc), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 7);

            $address = strtoupper($empresa->address);
            $h_address = 3;
            if (strlen($address) > 40) {
                $h_address = 5;
            }

            $pdf->SetY($espac);
            $pdf->SetX(3);
            $pdf->MultiCell($ancho - 5, 3, utf8_decode($address), 0, "C");
            $espac = $espac + $h_header + $h_address;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('TEL: ' . $empresa->telephone . ' - ' . $empresa->cellphone . ' / ' . $empresa->email), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 3;

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode($voucher['description']), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);
            $espac = $espac + $ancho_celda_datos + 3;

            $pdf->SetY($espac);
            $pdf->SetX(0);

        }
        else {

            $pdf->SetFont('Helvetica', 'B', 7);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($empresa->social_reason), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', 'B', 8);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode('RUC  ' . $empresa->ruc), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetFont('Helvetica', '', 7);

            $address = strtoupper($empresa->address);
            $h_address = 3;
            if (strlen($address) > 40) {
                $h_address = 5;
            }

            $pdf->SetY($espac);
            $pdf->SetX(3);
            $pdf->MultiCell($ancho - 5, 3, utf8_decode($address), 0, "C");
            $espac = $espac + $h_header + $h_address;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('TEL: ' . $empresa->telephone . ' - ' . $empresa->cellphone . ' / ' . $empresa->email), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 3;

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode($voucher['description']), 0, 0, 'C', 1);
            $espac = $espac + $h_header + 1;

            $pdf->SetY($espac);
            $pdf->SetX(0);
            $pdf->Cell($ancho, $h_header, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);
            $espac = $espac + $ancho_celda_datos + 3;

            $pdf->SetY($espac);
            $pdf->SetX(0);

        }


        //$pdf->Cell($ancho,$ancho_celda_datos,utf8_decode('Nº AUTORIZACIÓN: 0183845129037'),0,0,'C',1);


        //DATOS DE EMISION DE LA VENTA
        $pdf->SetFont('Helvetica', '', 7);
        $fecha = date("d/m/Y", strtotime($movimiento['date_movement']));
        $hora = date("H:i:s", strtotime($movimiento['date_movement']));

        $pdf->SetY($espac);
        $pdf->SetX($margin_side);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('F. Emisión: ' . $fecha . ' -- ' . $hora), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;

        if ($venta['typetransaction_id'] == config('app.transaction_credit')) {
            $schedule = $this->rScheduleSale->findBySale($venta['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);
            $pdf->SetY($espac);
            $pdf->SetX($margin_side);
            $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('F. Vcto.     : ' .$schedule_detail->last()->date_assigned), 0, 0, 'L', 1);
            $espac = $espac + $ancho_celda_datos;
        }

        $label_comprobante = $cliente->typeDocument;

        $pdf->SetY($espac);
        $pdf->SetX(2);
        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode($label_comprobante), 0, 36), 0, 0, 'L', 1);
        $pdf->SetX(15);
        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode($cliente['document']), 0, 36), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;


        $pdf->SetY($espac);
        $pdf->SetX(2);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode('Cliente:'), 0, 0, 'L', 1);
        $pdf->SetFont('Helvetica', '', 6);
        $pdf->SetX(15);
        $pdf->Cell($ancho, $ancho_celda_datos, utf8_decode($cliente['fullname']), 0, 0, 'L', 1);
        $espac = $espac + $ancho_celda_datos;

        $pdf->SetFont('Helvetica', '', 7);
        $pdf->SetY($espac);
        $pdf->SetX(2);
        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode('Dirección:'), 0, 36), 0, 0, 'L', 1);
        $pdf->SetFont('Helvetica', '', 6);
        $pdf->SetX(15);
//        $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode($cliente['address']), 0, 36), 0, 0, 'L', 1);
        $pdf->MultiCell($ancho - 20, 3, utf8_decode($cliente['address']), 0);


        $espac = $espac + $ancho_celda_datos;

        //**
        //TODO: REORGANIZAR CODIGO  CUANDO TODAS LAS MIGRACIONES TENGAN EL CAMPO "OBSERVATION"
        if (isset($venta['observation'])) {
            $pdf->SetFont('Helvetica', '', 7);
            $pdf->SetY($espac);
            $pdf->SetX(2);
            $pdf->Cell($ancho, $ancho_celda_datos, substr(utf8_decode('Obs.:'), 0, 36), 0, 0, 'L', 1);
            $pdf->SetFont('Helvetica', '', 6);
            $pdf->SetX(15);
            $pdf->MultiCell($ancho - 20, 3, utf8_decode($venta['observation']), 0);
        }
        //**

        $espac = $espac + $ancho_celda_datos + 2;

        $espac = $espac + 1 - 3;
        $sbtotal = 0;
        $sumaIgv = 0;

        $code_leyenda = config('app.code_leyenda_bienes_exonerado');
        $txt_leyenda = config('app.txt_leyenda_bienes_exonerado');


        // detail columns
        $cols_detail = $this->get_columns_detail_ticket();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetFillColor(245, 245, 245);
        $pdf->SetY($espac);
        $pdf->SetX(2);
        $pdf->SetHeight(6);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(4);
        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetFillColor(255, 255, 255);

        if ($venta['is_grouped'] == true) {
            $row_grouped = array(
                'quantity' => 1,
                'unit' => 'NIU',
                'description' => $venta['description_grouped'],
                'price' => $venta['total'],
                'total' => $venta['total']
            );

            foreach ($rows as $row) {
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $sbtotal = $sbtotal + $subtotal;
            }

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row_grouped{$field}) ? utf8_decode($row_grouped{$field}) : "";
            }

            $pdf->SetX(2);
            $pdf->Row($values, $cols_pos, "Y", "Y");

            $aditional = 0;
            if (strlen($row_grouped['description']) > 25) {
                $divider = strlen($row_grouped['description']) / 25;
                $aditional = round($divider) + 20;
            }

            $espac = $espac + $pdf->GetHeight() + $aditional;
        } else {
            foreach ($rows as $row) {
                $pdf->SetX(2);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if($row['igv'] != null){
                    $subtotal = ($row['price'] * $row['quantity']) + $row['igv'] ;
                }

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                // CUSTOM DESCRIPTION
                $row['description'] = $product['description'];

                if($product['typeprice_id'] == config('app.catalog_price_variant')){
                    $variant = $this->rProductVariant->find($row['productvariant_id']);
                    $row['description'] = $row['description']."\n".$variant['type'];
                }

                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $values = array();
                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $sbtotal = $sbtotal + $subtotal;

//                $pdf->Row($values, $cols_pos, "Y", "Y");

                $pdf->SetFont('Arial', 'B', 5.5);
                $pdf->SetHeight(3.5);
                $pdf->SetWidths(array(22,10,7,14,15));
                $pdf->Row(array($product->code, $row['quantity'],$row['unit'],$row['price'], $row['total']),array("L", "C", "C" ,"C", "R"), "N", "Y");

                $pdf->SetFont('Arial', '', 5);
                $pdf->SetX(2);
                $pdf->SetHeight(3);
                $pdf->SetWidths(array(60));
                $pdf->Row(array(utf8_decode($row['description'])),array("L"),"N", "Y");

                $pdf->SetX(2);
                $pdf->SetHeight(1.2);
                $pdf->SetWidths(array(68));
                $pdf->Row(array(utf8_decode("......................................................................................................................................")),array("L"), "N", "Y");


                $aditional = 0;
                if (strlen($row->description) > 60) {
                    $divider = strlen($row->description) / 60;
                    $aditional = round($divider) + 3;
                }

//                dd($pdf->GetHeight());

                $espac = $espac + 7.7 + $aditional;
            }
        }

        $pdf->SetWidths(array(25));
        $pdf->Row(array(utf8_decode("\n .")),array("L"),"N", "Y");

        // RESUMEN DE VENTA
        $pdf->SetFont('Arial', 'B', 7);

        $pdf->SetHeight(4);
        $pdf->SetX(31);
        $pdf->SetWidths(array(25,15));
        $pdf->Row(array(utf8_decode($data['totales']['title_ticket']), utf8_decode('S/ ' . number_format($data['totales']['total_sale'], 2))),array("L","R"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX(31);
        $pdf->SetWidths(array(25,15));
        $pdf->Row(array(utf8_decode("IGV"), utf8_decode('S/ ' . number_format($data['totales']['total_taxed'], 2))),array("L","R"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX(31);
        $pdf->SetWidths(array(25,15));
        $pdf->Row(array(utf8_decode("TOTAL PAGAR"), utf8_decode('S/ ' . number_format($data['totales']['total_paid'], 2))),array("L","R"),"N", "Y");

        $pdf->SetFont('Arial', 'B', 6);
        $pdf->SetHeight(6);
        $pdf->SetX(2);
        $pdf->SetWidths(array(8,65));
        $pdf->Row(array(utf8_decode("SON :"), utf8_decode($movimiento['text_amount'])),array("L","L"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX(2);
        $pdf->SetWidths(array(22,40));
        $pdf->Row(array(utf8_decode("CONDICIÓN PAGO:"), utf8_decode(strtoupper($venta['typetransaction']))),array("L","L"),"N", "Y");

        if($venta['typetransaction_id'] == config('app.transaction_cash')){

            $pdf->SetHeight(4);
            $pdf->SetX(2);
            $pdf->SetWidths(array(22,40));
            $pdf->Row(array(utf8_decode("MEDIO DE PAGO:"), utf8_decode(strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description']))),array("L","L"),"N", "Y");

        }else{

            $schedule = $this->rScheduleSale->findBySale($venta['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);

            //  N° cuotas credito
            $pdf->SetHeight(4);
            $pdf->SetX(2);
            $pdf->SetWidths(array(22,40));
            $pdf->Row(array(utf8_decode("N° DE CUOTAS :"), utf8_decode(count($schedule_detail))),array("L","L"),"N", "Y");

            //  fecha venciemiento credito
            $pdf->SetHeight(4);
            $pdf->SetX(2);
            $pdf->SetWidths(array(25,40));
            $pdf->Row(array(utf8_decode("FECHA VENC. CRED. :"), utf8_decode($schedule_detail[0]['date_assigned'])),array("L","L"),"N", "Y");

            $espac  = $espac + 4;
        }


//        $espac = $espac + 15;
//        $pdf->SetY($espac);

        $pdf->SetFont('Arial', 'B', 6);

        $pdf->SetHeight(6);
        $pdf->SetX(2);
        $pdf->SetWidths(array(50));
        $pdf->Row(array(utf8_decode("Leyendas :")),array("L","L"),"N", "Y");

        $pdf->SetHeight(4);
        $pdf->SetX(2);
        $pdf->SetWidths(array(70));
        $pdf->Row(array(utf8_decode($code_leyenda . ': ' . $txt_leyenda)),array("L","L"),"N", "Y");


        $espac  = $espac + 50;

        $dataImg = array(
            $empresa['ruc'],
            $movimiento['voucher_id'],
            $movimiento['serie'],
            $movimiento['correlative'],
            $venta['total'],
            date('Y-m-d', strtotime($venta['date_sale'])),
            $cliente['typedocument_id'],
            $cliente['document'],
            ""
        );

        $fileTmp = "archivos/" . $empresa['ruc'] . "-" . $movimiento['voucher_id'] . "-" . $movimiento['nro_voucher'] . ".png";
        QrCode::format('png')->size(1)->margin(0)->generate(implode("|", $dataImg), $fileTmp, QR_ECLEVEL_Q, 2, 1);

        if (file_exists($fileTmp)) {
            $imagen_qr_encode = base64_encode(file_get_contents($fileTmp));
            $pic = 'data://text/plain;base64,' . $imagen_qr_encode;
            $info = getimagesize($pic);
            unlink($fileTmp);
            $pdf->Image($pic, 3, $espac, 20, 20, 'png');
        }

        $pdf->SetFont('Arial', 'B', 5.5);
        $pdf->SetY($espac);

        $pdf->SetHeight(3);
        $pdf->SetX(25);
        $pdf->SetWidths(array(48));
        $pdf->Row(array(utf8_decode("Representación impresa de la ".$voucher['description'].". Para consultar el comprobante ingresar a: \n".utf8_decode($empresa['api_facturador'] . '/buscar'))),array("L","L"),"N", "Y");

        $pdf->SetFont('Arial', 'B', 5);
        $pdf->SetHeight(3);
        $pdf->SetX(25);
        $pdf->SetWidths(array(48));
        $pdf->Row(array(utf8_decode("\n Código Hash: ".$movimiento['billing_hash'])),array("L","L"),"N", "Y");


        $pdf->AutoPrint();
        $pdf->output();
        exit;
    }

    public function getTicketStructure($data, $h_header, $h_logo, $h_celda, $h_qr)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $cliente = $data['cliente'];
        $movimiento = $data['movimiento'];
        $voucher = $data['voucher'];
        $items = count($data['items']);
        $detail = $data['items'];

        $sum = 0;
        $altura_inicial = 7;

        $sum = $sum + $altura_inicial;

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa->url_image;
            $sum = $sum + $h_logo * 2;
        }

        $txt_tradename = $empresa->tradename;
        if ($txt_tradename != null or $txt_tradename != '') {
            $sum = $sum + 4 * $h_header + 4;
        } else {
            $sum = $sum + 3 * $h_header + 3;
        }

        // serie y correlativo
        $sum = $sum + 2 * $h_header + 4;

        // datos de la venta
        $sum = $sum + 5 * $h_header + 2;

        // header detalle de la venta
        $sum = $sum + $h_header + 2;

        $rows = $detail;

        foreach ($rows as $row) {
            $product = $this->rProduct->find($row['product_id']);
            $aditional = 0;
            if (strlen($product->description) > 65) {
                $divider = strlen($product->description) / 65;
                $aditional = round($divider) + 5;
            }

//            $sum = $sum + 4 + $aditional;
            $sum = $sum + 10 + $aditional;
        }

//        // resumen de venta
//        $sum = $sum + 3 * $h_header + 5;
//
//        // texto total y leyenda
//        $sum = $sum + 4 * $h_celda + 20;
//
//        // qrcode y codigo hash
//        $sum = $sum + $h_qr + 5;
//
//        // footer and consulta
//        $sum = $sum + 2 * $h_celda + 10 - 10 + 30;

        $sum = $sum + 65;

        return $sum;
    }

    public function getCommandStructure($data, $h_header, $h_logo, $h_celda, $h_qr, $delivery_data)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $items = count($data['items']);
        $detail = $data['items'];

        $sum = 0;
        $altura_inicial = 5;

        $sum = $sum + $altura_inicial;

        // serie y correlativo
        $sum = $sum + 2 * $h_header + 4;

        // datos de la venta
        $sum = $sum + 2 * $h_header + 2;

        // header detalle de la venta
        $sum = $sum + $h_header + 2;

        $rows = $detail;

        foreach ($rows as $row) {
//            $aditional = 0;
//            if (strlen($row->description) > 25) {
//                $divider = strlen($row->description) / 25;
//                $aditional = round($divider) + 2;
//            }
//            $sum = $sum + 4 + $aditional;
            $product = $this->rProduct->find($row['product_id']);
            $aditional = 0;
            if (strlen($product->description) > 65) {
                $divider = strlen($product->description) / 65;
                $aditional = round($divider) + 5;
            }
            $sum = $sum + 7.7 + $aditional;
        }

//        // resumen de venta
//        $sum = $sum + 3 * $h_header + 5;
//
//        // texto total y leyenda
//        $sum = $sum + 2 * $h_celda + 20;

        if($venta->is_delivered) {
            if ($delivery_data->observation != null) {
                $sum = $sum + 50;
                $obs_len = strlen($delivery_data->observation);
                while ($obs_len > 60) {
                    $sum = $sum + 10;
                    $obs_len = $obs_len - 60;
                }
            } else {
                $sum = $sum + 50;
            }
        }else{
            $sum = $sum + 40;
        }

        return $sum;
    }

    protected function get_columns_detail_a4()
    {
        return array(
            "quantity" => array("col" => "A", "label" => "Cant.", "pos" => "C", "width" => 20)
        , "unit" => array("col" => "B", "label" => "Unidad", "pos" => "C", "width" => 25)
        , "description" => array("col" => "C", "label" => utf8_decode("Descripción"), "pos" => "L", "width" => 105)
        , "price" => array("col" => "D", "label" => "Precio", "pos" => "C", "width" => 20)
        , "total" => array("col" => "E", "label" => "Total", "pos" => "R", "width" => 30)
        );
    }

    protected function get_columns_detail_proforma_a4()
    {
        return array(
            "quantity" => array("col" => "A", "label" => "Cant.", "pos" => "C", "width" => 20)
        , "unit" => array("col" => "B", "label" => "Unidad", "pos" => "C", "width" => 20)
        , "description" => array("col" => "C", "label" => utf8_decode("Descripción"), "pos" => "L", "width" => 70)
        , "price" => array("col" => "D", "label" => "Precio", "pos" => "C", "width" => 20)
        , "subtotal" => array("col" => "E", "label" => "Subtotal", "pos" => "R", "width" => 25)
        , "igv" => array("col" => "D", "label" => "Igv", "pos" => "C", "width" => 20)
        , "total" => array("col" => "E", "label" => "Imp. total", "pos" => "R", "width" => 25)
        );
    }

    protected function get_columns_detail_ticket()
    {
        return array(
            "description" => array("col" => "C", "label" => utf8_decode("Producto"), "pos" => "L", "width" => 22)

        , "quantity" => array("col" => "A", "label" => "Cant", "pos" => "C", "width" => 10)
        , "unit" => array("col" => "B", "label" => "Und", "pos" => "C", "width" => 7)

        , "price" => array("col" => "D", "label" => "Precio", "pos" => "C", "width" => 14)
//        , "igv" => array("col" => "D", "label" => "Igv", "pos" => "C", "width" => 9)
        , "total" => array("col" => "E", "label" => "Subtotal", "pos" => "R", "width" => 15)
        );
    }

    protected function get_columns_detail_ticket_cbx()
    {
        return array(
            "description" => array("col" => "C", "label" => utf8_decode("Producto"), "pos" => "L", "width" => 20)

        , "quantity" => array("col" => "A", "label" => "Cant", "pos" => "C", "width" => 14)
        , "unit" => array("col" => "B", "label" => "Und", "pos" => "C", "width" => 8)

        , "price" => array("col" => "D", "label" => "Precio", "pos" => "C", "width" => 15)
//        , "igv" => array("col" => "D", "label" => "Igv", "pos" => "C", "width" => 9)
        , "total" => array("col" => "E", "label" => "Total", "pos" => "R", "width" => 16.5)
        );
    }

    public function printExpenseDocument($id)
    {
//        try {
        $empresa = $this->tenant->company();
        $sucursal = $this->rBranchOffice->find($this->utilHelper->getBranchOffice());
        $movimiento = $this->rMoneyMovement->find($id);
        $voucher = $this->rTypeVoucher->find($movimiento['voucher_id']);


        $pdf = new \App\Libraries\Pdf();
        $pdf->AliasNbPages(); // para el conteo de paginas
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        // espacios iniciales
        $ancho_total = 210;
        $height_total = 148;
        $espac = 3;
        $pos_initial_x = 3;
        $separetor_coluns = 5;
        $h_row = 3.1;
        $h_logo = 20;
        $w_logo = 33;

        $pdf->AddPage('L', 'A5', 0, 1);

        // CUADRADO TOTAL DE LA PAGINA
        $pdf->SetFillColor(255, 255, 255);

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa->url_image;
        }

        $pdf->Image($logo_empresa, $pos_initial_x + 3, $espac + 2, $w_logo, $h_logo);

        $initial_head = 5;
        $w_head = 112;

        $txt_razon_empresa = $empresa->social_reason;

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($initial_head);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
        $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_razon_empresa), 0);

        if (strlen($txt_razon_empresa) > 28) {
            $initial_head = $initial_head + $h_row - 0.5;
        }

        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetY(2.1 * $initial_head);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
        $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

        $txt_address = strtoupper(utf8_decode($sucursal['address'])) . "\nTEL: " . $empresa['telephone'] . "   -   " . $empresa['email'];

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY(3 * $initial_head);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns * 2);
        $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        // cuadradito para numero de factura
//        $pdf->SetFillColor(245,245,245);
        $position_invoice_square = $pos_initial_x + $w_logo + $separetor_coluns + $w_head + $separetor_coluns;
        $w_invoice_square = $ancho_total - $position_invoice_square - 6;
        $pdf->RoundedRect($position_invoice_square, $espac + 1, $w_invoice_square, 17.5, 2, '1234', 'FD');

        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetY($espac + 5);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($voucher['description']), 0, 0, 'C', 1);

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($espac + 12);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);


        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetFont('Arial', '', 9);
        $espac = $espac + $initial_head + 25;
        $fecha = date("d/m/Y", strtotime($movimiento['date_movement']));
        $hora = date("H:i:s", strtotime($movimiento['date_movement']));

        $side_r = 3;
        $w_initial = 20;
        $w_final = 140;
        $pos_x_h = $pos_initial_x + $side_r;
        $separador_row = 2;
        $space_temp = $espac - 2;
        $h_row = 3;

        $label_referencia = 'REFERENCIA';
        $referencia = '-';
        $document = '-';
        $person = null;

        if ($movimiento['client_id'] != null) {
            $label_referencia = 'CLIENTE';
            $person = $this->rClient->find($movimiento['client_id']);
            $referencia = $person['fullname'];
            $document = $person['document'];
        }

        if ($movimiento['provider_id'] != null) {
            $label_referencia = 'PROVEEDOR';
            $person = $this->rProvider->find($movimiento['provider_id']);
            $referencia = $person['fullname'];
            $document = $person['document'];
        }

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode($label_referencia), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $referencia), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $label_comprobante = "DOCUMENTO";

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode($label_comprobante), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $document), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('DIRECCIÓN'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);

        $cellphone = '';
        if (isset($person['cellphone']))
            if ($person['cellphone'] != null)
                $cellphone = '    -    Cel. ' . $person['cellphone'];

        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $person['address'] . $cellphone), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('CONCEPTO'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . strtoupper($this->rMoneyConcept->find($movimiento['concept_id'])['description'])), 0, 0, 'L', 1);

        $w_initial = $w_initial + 5;

        $pos_x_h = $pos_initial_x + $side_r + $w_final + $side_r;
        $w_final_col = $ancho_total - ($pos_x_h + $w_initial + $side_r) - 10;

        $space_temp = $espac - 2;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('F. EMISIÓN'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $fecha), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('MÉTODO PAGO'), 0, 0, 'L', 1);
        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description'])), 0, 0, 'L', 1);

        $espac = $espac + 20;

        $position_invoice_square = $pos_initial_x + $side_r;
        $w_invoice_square = $ancho_total - $position_invoice_square - 6;
        $pdf->RoundedRect($position_invoice_square, $espac, $w_invoice_square, 55, 0, '1234', 'FD');


        $pdf->SetFont('Arial', 'B', 10);

        $pdf->SetY($espac);
        $pdf->SetX($pos_initial_x + $side_r);

        $width_description = $pos_initial_x + $side_r + 150;
        $width_amount = $ancho_total - $width_description - 12;

        $pdf->SetWidths(array($width_description, $width_amount));
        $pdf->SetHeight(8);
        $pdf->SetFillColor(245, 245, 245);
        $pdf->Row(array(utf8_decode('DESCRIPCIÓN'), 'MONTO'), array("C", "C"), "Y", "Y", array(245, 245, 245), false, false, true);


        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetFont('Arial', '', 10);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->SetWidths(array($width_description, $width_amount));
        $pdf->Row(array(strtoupper(utf8_decode($movimiento['gloss'])), utf8_decode('S/ ' . number_format(($movimiento['amount']), 2))), array("L", "C"), "N", "Y", array(), false, array(6, 10));


        if ($movimiento['is_voucher_external']) {
            $pdf->SetX($pos_initial_x + $side_r);
            $pdf->SetWidths(array($width_description));
            $pdf->Row(array(utf8_decode("Incluye comprobante " . $this->rTypeVoucher->find($movimiento['voucher_external'])['description'] . ' - ' . $movimiento['nro_voucher_external'])), array("L", "C"), "N", "Y");
        }

        $pdf->SetAutoPageBreak(false);

        $pdf->SetFont('Arial', 'B', 11);
        $pdf->SetY($espac + 60);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->Cell($width_description, $h_row, utf8_decode('TOTAL :'), 0, 0, 'R', 1);

        $pdf->SetY($espac + 60);
        $pdf->SetX($pos_initial_x + $side_r + $width_description);
        $pdf->Cell($width_amount, $h_row, utf8_decode('S/ ' . number_format(($movimiento['amount']), 2)), 0, 0, 'C', 1);


        $pdf->SetFont('Arial', '', 9);

        $espac = $espac + 55 + 25;
        $posx_responsable = $pos_initial_x + 15 + $side_r;
        $pdf->SetY($espac);
        $pdf->SetX($posx_responsable);
        $pdf->Cell($w_initial, $h_row, utf8_decode('...........................................................'), 0, 0, 'C', 1);

        $pdf->SetY($espac + 5);
        $pdf->SetX($posx_responsable);
        $pdf->Cell($w_initial, $h_row, utf8_decode('RESPONSABLE'), 0, 0, 'C', 1);

        $pdf->SetY($espac);
        $pdf->SetX($posx_responsable + 75);
        $pdf->Cell($w_initial, $h_row, utf8_decode('..................................................................'), 0, 0, 'C', 1);

        $pdf->SetY($espac + 5);
        $pdf->SetX($posx_responsable + 75);
        $pdf->Cell($w_initial, $h_row, utf8_decode('ACEPTADO, N° DNI. + FIRMA O SELLO'), 0, 0, 'C', 1);


        $pdf->Output();
//        } catch (\Exception $e) {
//            return response()->json($e->getMessage(), 400);
//        }
    }

    public function printProformaDocument($proforma_id, $send_email = false)
    {
        $empresa = $this->tenant->company();
        $proforma = $this->rProforma->findJoined($proforma_id);
        $voucher = $this->rTypeVoucher->find($proforma['voucher_id']);
        $cliente = $this->rClient->find($proforma['client_id']);
        $detail = $this->rProformaDetail->findByProformaIdJoined($proforma['id']);

        $pdf = new \App\Libraries\Pdf();

        $pdf->AliasNbPages(); // para el conteo de paginas
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        // espacios iniciales
        $ancho_total = 210;
        $height_total = 297;
        $espac = 5;
        $pos_initial_x = 5;
        $separetor_coluns = 5;
        $h_row = 3.5;
        $h_logo = 27;
        $w_logo = 47;

        $pdf->AddPage('P', 'A4');

        // CUADRADO TOTAL DE LA PAGINA
        $pdf->SetFillColor(255, 255, 255);
        // $pdf->RoundedRect($pos_initial_x, $espac, $ancho_total - ($pos_initial_x + $espac), $height_total - ($pos_initial_x + $espac), 2, '1234', 'S');

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa['url_image'];
        }

        $pdf->Image($logo_empresa, $pos_initial_x + 3, $espac + 1, $w_logo, $h_logo);

        $initial_head = 12;
        $w_head = 80;
        $txt_razon_empresa = $empresa['social_reason'];

        $pdf->SetFont('Arial', '', 12);
        $pdf->SetY($initial_head - 2);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
        $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_razon_empresa), 0);

        if (strlen($txt_razon_empresa) > 28) {
            $initial_head = $initial_head + $h_row - 0.5;
        }

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY(1.5 * $initial_head - 1);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
        $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

        $txt_address = utf8_decode($empresa['address']) . "\nTEL: " . $empresa['telephone'] . "   -   " . $empresa['email'];

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY(1.85 * $initial_head);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
        $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetTextColor(51, 102, 255);
        $pdf->SetY($espac + 26);
        $pdf->SetX($pos_initial_x + 5);
        $pdf->MultiCell(130, $h_row, utf8_decode($empresa['offers_description']), 0);

        $pdf->SetTextColor(0, 0, 0);

        // cuadradito para numero de factura
        $pdf->SetFillColor(245, 245, 240);
        $position_invoice_square = $pos_initial_x + $w_logo + $separetor_coluns + $w_head + $separetor_coluns + 10;
        $w_invoice_square = $ancho_total - $position_invoice_square - 8;
//        $pdf->SetDrawColor(51, 102, 255);
        $pdf->RoundedRect($position_invoice_square, $espac + 5, $w_invoice_square, 20, 2, '1234', 'FD');

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($espac + 9);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($voucher['description']), 0, 0, 'C', 1);

        $pdf->SetFont('Arial', 'B', 15);
        $pdf->SetY($espac + 17);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($proforma['nro_voucher']), 0, 0, 'C', 1);


        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetFont('Arial', '', 9);
        $espac = $espac + $initial_head + 25;
        $fecha = date("d/m/Y", strtotime($proforma['date_issue']));
        $fecha_vencimiento = date("d/m/Y", strtotime($proforma['date_expiration']));

        $side_r = 5;
        $w_initial = 20;
        $w_final = 125;
        $pos_x_h = $pos_initial_x + $side_r;
        $separador_row = 2;
        $space_temp = $espac;

        $label_comprobante = $cliente->typeDocument;

        $pdf->RoundedRect($pos_x_h - 2, $espac - 2, 194, 20, 2, '1234', 'FD');

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode($label_comprobante), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['document']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Cliente'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['fullname']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Dirección'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $cliente['address']), 0);

        $w_initial = $w_initial + 5;

        $pos_x_h = $pos_initial_x + $side_r + $w_final + $side_r;
        $w_final_col = $ancho_total - ($pos_x_h + $w_initial + $side_r) - 10;

        $space_temp = $espac;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Emisión'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $fecha), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Vencimiento'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $fecha_vencimiento), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('N° celular'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $cliente['cellphone']), 0, 0, 'L', 1);

        $espac = $espac + 2;
        $sbtotal = 0;
        $sumaIgv = 0;

        // detail columns
        $cols_detail = $this->get_columns_detail_proforma_a4();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetFillColor(245, 245, 245);
        $pdf->SetY(65);
        $pdf->SetX($pos_initial_x);
        $pdf->SetHeight(7);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(5);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetFillColor(255, 255, 255);

        $additional_lines = 0;

        foreach ($rows as $row) {
            $pdf->SetX($pos_initial_x);
            $product = $this->rProduct->find($row['product_id']);
            $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
            $subtotal = $row['price'] * $row['quantity'];
            $total = $row['price'] * $row['quantity'] + $row['igv'];

            $row['description'] = $product['description'];
            $row['unit'] = $unit['prefix'];
            $row['subtotal'] = number_format($subtotal, 2);
            $row['total'] = number_format($total, 2);

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
            }

            $sbtotal = $sbtotal + $subtotal;

            $sumaIgv = $sumaIgv + $row['igv'];

            if(utf8_decode(mb_strlen($product['description'])) > 40){
                $additional_lines = $additional_lines + 5;
            }

            $pdf->Row($values, $cols_pos, "Y", "Y");
        }

        $pdf->SetAutoPageBreak(false);

        $initial_footer = 240;
        $check_espace = 65 + count($rows)*5 + $additional_lines;
        $w_txt_qr = 80;
        
        // dd($check_espace);

        if($check_espace >= 240 and $check_espace <= 279){
            $pdf->AddPage();
            // $i = $check_espace;            
            // while ($i >= 240) {
            //     $i = $i - 297; 
            // }           
            $initial_footer = 20;
        }
        elseif($check_espace >= 280){
            $i = $check_espace;            
            while ($i >= 240) {
                $i = $i - 297; 
            }           
            $initial_footer = $i + 65;
        }
        else{
            $pdf->SetY($initial_footer);
        }

        $pos_qr_y = $initial_footer;
        $w_qr = 40;
        $w_txt_qr = 80;


        $pdf->Line($pos_initial_x, $initial_footer - 10, $ancho_total - $side_r, $initial_footer - 10); // 20mm from each edge

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($initial_footer - 7);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Son : " . $proforma['text_amount']), 0);

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($initial_footer);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr, $h_row, utf8_decode("OBSERVACIONES: " . $proforma['observation']), 0);

        $pdf->SetFont('Arial', 'UB', 8);
        $pdf->SetY($initial_footer + 10);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("CUENTA PARA DEPÓSITO"), 0);

        $nombre_banco = "-";
        $numero_cuenta = "-";
        $numero_cci = "-";
        $titular = "-";

        if ($proforma['accountbank_id'] != null) {
            $account_bank = $this->rAccountBank->find($proforma['accountbank_id']);
            $nombre_banco = $account_bank['bank'];
            $numero_cuenta = $account_bank['number_account'];
            $numero_cci = $account_bank['cci_account'];
            $titular = $account_bank['headline'];
        }

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($initial_footer + 15);
        $pdf->SetX($pos_initial_x + $side_r + 5);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Nombre Banco: " . $nombre_banco), 0);

        $pdf->SetY($initial_footer + 20);
        $pdf->SetX($pos_initial_x + $side_r + 5);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("N° cuenta: " . $numero_cuenta), 0);

        $pdf->SetY($initial_footer + 25);
        $pdf->SetX($pos_initial_x + $side_r + 5);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("N° CCI: " . $numero_cci), 0);

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY($initial_footer + 30);
        $pdf->SetX($pos_initial_x + $side_r + 5);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("TITULAR: " . $titular), 0);


        $msg_footer = "LOS PRODUCTOS SON ENTREGADOS A CONFORMIDAD DEL CLIENTE, AL MISMO TIEMPO TIENEN UN PROCESO DE GARANTIA EN CASO HUBIESE CUALQUIER FALLA DE FÁBRICA. SE OTORGA TODOS LOS DERECHOS Y GARANTÍAS DE MANERA LEGAL Y FORMAL";
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 20) + 3);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->SetTextColor(51, 102, 255);
        $pdf->MultiCell($w_txt_qr + 110, $h_row + 1, utf8_decode($msg_footer), 0, 'C');

        $pdf->SetTextColor(0, 0, 0);

        $w_summary_label = 40;
        $separetor_summary = 7;
        $initial_summary = $initial_footer - 5;

        $pdf->SetFont('Arial', 'B', 9);

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("SUBTOTAL:"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($sbtotal, 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IGV (18%)"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format(($sumaIgv), 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary + 2.5;

        $total = $sbtotal + ($sumaIgv);

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IMPORTE TOTAL"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($total, 2)), 0, 0, 'R', 1);

        if ($send_email == true) {
            return $pdf;
        } else {
            $pdf->Output();
        }
    }

    public function printOrderPurchaseDocument($order_id, $send_email = false)
    {
        $empresa = $this->tenant->company();
        $order = $this->rOrderPurchase->findJoined($order_id);
        $provider = $this->rProvider->find($order['provider_id']);
        $detail = $this->rOrderDetailPurchase->findByOrderIdJoined($order['id']);

        $pdf = new \App\Libraries\Pdf();

        $pdf->AliasNbPages(); // para el conteo de paginas
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        // espacios iniciales
        $ancho_total = 210;
        $height_total = 297;
        $espac = 5;
        $pos_initial_x = 5;
        $separetor_coluns = 5;
        $h_row = 3.5;
        $h_logo = 27;
        $w_logo = 47;

        $pdf->AddPage('P', 'A4');

        // CUADRADO TOTAL DE LA PAGINA
        $pdf->SetFillColor(255, 255, 255);
        $pdf->RoundedRect($pos_initial_x, $espac, $ancho_total - ($pos_initial_x + $espac), $height_total - ($pos_initial_x + $espac), 2, '1234', 'S');

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa['url_image'];
        }

        $pdf->Image($logo_empresa, $pos_initial_x + 3, $espac + 1, $w_logo, $h_logo);

        $initial_head = 12;
        $w_head = 80;
        $txt_razon_empresa = $empresa['social_reason'];

        $pdf->SetFont('Arial', '', 12);
        $pdf->SetY($initial_head - 2);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
        $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_razon_empresa), 0);

        if (strlen($txt_razon_empresa) > 28) {
            $initial_head = $initial_head + $h_row - 0.5;
        }

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY(1.5 * $initial_head - 1);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
        $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

        $txt_address = utf8_decode($empresa['address']) . "\nTEL: " . $empresa['telephone'] . "   -   " . $empresa['email'];

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY(1.85 * $initial_head);
        $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
        $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetTextColor(51, 102, 255);
        $pdf->SetY($espac + 26);
        $pdf->SetX($pos_initial_x + 5);
        $pdf->MultiCell(130, $h_row, utf8_decode($empresa['offers_description']), 0);

        $pdf->SetTextColor(0, 0, 0);

        // cuadradito para numero de factura
        $pdf->SetFillColor(245, 245, 240);
        $position_invoice_square = $pos_initial_x + $w_logo + $separetor_coluns + $w_head + $separetor_coluns + 10;
        $w_invoice_square = $ancho_total - $position_invoice_square - 8;
//        $pdf->SetDrawColor(51, 102, 255);
        $pdf->RoundedRect($position_invoice_square, $espac + 5, $w_invoice_square, 20, 2, '1234', 'FD');

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($espac + 9);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode("ORDEN DE COMPRA"), 0, 0, 'C', 1);

        $pdf->SetFont('Arial', 'B', 15);
        $pdf->SetY($espac + 17);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($order['code']), 0, 0, 'C', 1);


        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetFont('Arial', '', 9);
        $espac = $espac + $initial_head + 25;

        $side_r = 5;
        $w_initial = 20;
        $w_final = 125;
        $pos_x_h = $pos_initial_x + $side_r;
        $separador_row = 2;
        $space_temp = $espac;

        $pdf->RoundedRect($pos_x_h - 2, $espac - 2, 194, 25, 2, '1234', 'FD');

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('N° DOC'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $provider['document']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Proveedor'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $provider['fullname']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Dirección'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $provider['address']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('N° celular'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $provider['cellphone']), 0, 0, 'L', 1);

        $w_initial = $w_initial + 5;

        $pos_x_h = $pos_initial_x + $side_r + $w_final + $side_r;
        $w_final_col = $ancho_total - ($pos_x_h + $w_initial + $side_r) - 10;

        $space_temp = $espac;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Fecha para entrega'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . $order['date_order']), 0, 0, 'L', 1);


        $espac = $espac + 2;
        $sbtotal = 0;
        $sumaIgv = 0;

        // detail columns
        $cols_detail = array(
            "description" => array("col" => "C", "label" => utf8_decode("Descripción"), "pos" => "L", "width" => 120)
        , "unit" => array("col" => "B", "label" => "Unidad", "pos" => "C", "width" => 40)
        , "quantity" => array("col" => "A", "label" => "Cant.", "pos" => "C", "width" => 40)
//        , "price" => array("col" => "D", "label" => "Precio", "pos" => "C", "width" => 20)
//        , "subtotal" => array("col" => "E", "label" => "Subtotal", "pos" => "R", "width" => 25)
//        , "igv" => array("col" => "D", "label" => "Igv", "pos" => "C", "width" => 20)
//        , "total" => array("col" => "E", "label" => "Imp. total", "pos" => "R", "width" => 25)
        );
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;


        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetY(67.5);
        $pdf->SetX($pos_initial_x + 3);
        $pdf->SetWidths(array($ancho_total - $pos_initial_x * 2));
        $pdf->SetHeight(5);
        $pdf->Row(array(utf8_decode("TÉRMINOS DE ENTREGA: " . $order['delivery_terms'])), array("L"), "N", "Y");
        $pdf->SetX($pos_initial_x + 3);
        $pdf->Row(array(utf8_decode("OBSERVACIONES: " . $order['observation'])), array("L"), "N", "Y");
        $pdf->SetX($pos_initial_x + 3);
        $pdf->Row(array(utf8_decode("Sírvase por este medio poder sumunistrarnos los siguientes productos:" . ' Total ' . (count($detail)) . ' artículos')), array("L"), "N", "Y");

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetFillColor(245, 245, 245);

        $pdf->SetY(85);
        $pdf->SetX($pos_initial_x);
        $pdf->SetHeight(7);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(5);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetFillColor(255, 255, 255);

        foreach ($rows as $row) {
            $pdf->SetX($pos_initial_x);
            $product = $this->rProduct->find($row['product_id']);
            $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
            $subtotal = $row['price'] * $row['quantity'];
            $total = $row['price'] * $row['quantity'] + $row['igv'];

            $row['description'] = $product['description'];
            $row['unit'] = $unit['prefix'];
            $row['subtotal'] = number_format($subtotal, 2);
            $row['total'] = number_format($total, 2);

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
            }

            $sbtotal = $sbtotal + $subtotal;

            $sumaIgv = $sumaIgv + $row['igv'];

            $pdf->Row($values, $cols_pos, "Y", "Y");
        }

//        $pdf->SetAutoPageBreak(false);

//        $initial_footer = 240;
//
//        $pos_qr_y = $initial_footer;
//        $w_qr = 40;
//        $w_txt_qr = 80;
//
//
//        $pdf->Line($pos_initial_x, $initial_footer - 10, $ancho_total - $side_r, $initial_footer - 10); // 20mm from each edge
//
//        $pdf->SetFont('Arial', 'B', 8);
//        $pdf->SetY($initial_footer - 7);
//        $pdf->SetX($pos_initial_x + $side_r);
//        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Son : ".$order['text_amount'] ), 0);
//
//        $pdf->SetFont('Arial', '', 8);
//        $pdf->SetY($initial_footer);
//        $pdf->SetX($pos_initial_x + $side_r);
//        $pdf->MultiCell($w_txt_qr + $w_qr, $h_row, utf8_decode("OBSERVACIONES: ".$proforma['observation'] ), 0);
//
//        $pdf->SetFont('Arial', 'UB', 8);
//        $pdf->SetY($initial_footer+10);
//        $pdf->SetX($pos_initial_x + $side_r);
//        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("CUENTA PARA DEPÓSITO" ), 0);
//
//        $nombre_banco = "-";
//        $numero_cuenta = "-";
//        $numero_cci = "-";
//        $titular = "-";
//
//        if($proforma['accountbank_id'] != null){
//            $account_bank = $this->rAccountBank->find($proforma['accountbank_id']);
//            $nombre_banco = $account_bank['bank'];
//            $numero_cuenta = $account_bank['number_account'];
//            $numero_cci = $account_bank['cci_account'];
//            $titular = $account_bank['headline'];
//        }
//
//        $pdf->SetFont('Arial', '', 8);
//        $pdf->SetY($initial_footer+15);
//        $pdf->SetX($pos_initial_x + $side_r + 5);
//        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Nombre Banco: ".$nombre_banco), 0);
//
//        $pdf->SetY($initial_footer+20);
//        $pdf->SetX($pos_initial_x + $side_r + 5);
//        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("N° cuenta: ".$numero_cuenta), 0);
//
//        $pdf->SetY($initial_footer+25);
//        $pdf->SetX($pos_initial_x + $side_r + 5);
//        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("N° CCI: ".$numero_cci), 0);
//
//        $pdf->SetFont('Arial', 'B', 8);
//        $pdf->SetY($initial_footer+30);
//        $pdf->SetX($pos_initial_x + $side_r + 5);
//        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("TITULAR: ".$titular), 0);
//
//
//        $msg_footer = "LOS PRODUCTOS SON ENTREGADOS A CONFORMIDAD DEL CLIENTE, AL MISMO TIEMPO TIENEN UN PROCESO DE GARANTIA EN CASO HUBIESE CUALQUIER FALLA DE FÁBRICA. SE OTORGA TODOS LOS DERECHOS Y GARANTÍAS DE MANERA LEGAL Y FORMAL";
//        $pdf->SetFont('Arial', '', 8);
//        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 20) + 3);
//        $pdf->SetX($pos_initial_x + $side_r);
//        $pdf->SetTextColor(51, 102, 255);
//        $pdf->MultiCell($w_txt_qr + 110, $h_row + 1, utf8_decode($msg_footer), 0, 'C');
//
//        $pdf->SetTextColor(0,0,0);
//
//        $w_summary_label = 40;
//        $separetor_summary = 7;
//        $initial_summary = $initial_footer - 5;
//
//        $pdf->SetFont('Arial', 'B', 9);
//
//        $pdf->SetY($initial_summary);
//        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
//        $pdf->Cell($w_summary_label, $h_row, utf8_decode("SUBTOTAL:"), 0, 0, 'R', 1);
//        $pdf->SetX($ancho_total - $w_summary_label);
//        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($sbtotal, 2)), 0, 0, 'R', 1);
//
//        $initial_summary = $initial_summary + $separetor_summary;
//
//        $pdf->SetY($initial_summary);
//        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
//        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IGV (18%)"), 0, 0, 'R', 1);
//        $pdf->SetX($ancho_total - $w_summary_label);
//        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format(($sumaIgv), 2)), 0, 0, 'R', 1);
//
//        $initial_summary = $initial_summary + $separetor_summary + 2.5;
//
//        $total = $sbtotal + ($sumaIgv);
//
//        $pdf->SetFont('Arial', 'B', 9);
//        $pdf->SetY($initial_summary);
//        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
//        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IMPORTE TOTAL"), 0, 0, 'R', 1);
//        $pdf->SetX($ancho_total - $w_summary_label);
//        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($total, 2)), 0, 0, 'R', 1);

        if ($send_email == true) {
            return $pdf;
        } else {
            $pdf->Output();
        }
    }

    public function productsBarcode($product_id , $iterate_val)
    {
        $ticketera = "argus";
        // $ticketera = "argus_cp2140";

        $website_id = $this->tenant->hostname()->website_id;
        $website_panchito = 59;
        // $website_joyeria_angel = 155;
        $website_joyeria_angel = 0;
        $website_inversiones_rondoy = 177;
        // $website_inversiones_rondoy = 177;

        if($website_id == $website_panchito){
            $ticketera = "tsc";
        }
        else if($website_id == $website_joyeria_angel){
            $ticketera = "argus_cp2140";
        }
        else if($website_id == $website_inversiones_rondoy){
            $ticketera = "cp_2140m";
        }

        $pdf = new \App\Libraries\FpdfCode128();

        if($ticketera == "tsc"){

            $pdf->SetMargins(0,0,0,0);
            $pdf->AddPage('P', array(101.6, 152.4), 'O');
            $pdf->SetAutoPageBreak(false);

            $initial_x = 2;
            $initial_y = 30;
            $w_barcode = 45;
            $h_barcode = 14;

            $espace = 25;

            $h_name_product = 6;
            $h_price_product = 12;

            $product = $this->rProduct->find($product_id);
            $iterate = $iterate_val;

            $in = utf8_decode($product->description);
            $name_product = strlen($in) > 35 ? substr($in,0,35)."..." : $in;

            if($iterate == 3){
                $initial_y = 71;
                $espace = 29.5;
            }
            else if($iterate == 2){
                $initial_y = 100;
                $espace = 30;
            }
            else{
                $initial_y = 130;
                $espace = 0;
            }



            for($i=1; $i<=$iterate; $i++){
                for($j=1; $j<=2; $j++){
                    $code= $product->code;
                    $pdf->Code128($initial_x,$initial_y,$code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',6);
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',9);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));

                    $code= $product->code;
                    $pdf->Code128($initial_x + 53,$initial_y, $code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x + 52,$initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',6);
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x + 52,$initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',9);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));
                }

                $initial_y = $initial_y + $espace;
            }

            $pdf->Output("I");
            dd("end page");

        }else if($ticketera == "argus_cp2140"){


            $pdf->SetMargins(0,0,0,0);
//            $pdf->AddPage('P', array(104.1, 152.4), 'O');
            $pdf->AddPage('P', array(70, 150), 'O');
            $pdf->SetAutoPageBreak(false);

//            $initial_x = 2;
            $initial_x = 4.95;
            $initial_y = 5;
            $w_barcode = 29;
            $h_barcode = 5;

            $espace = 25;

            $h_name_product = 6;
            $h_price_product = 12;

            $product = $this->rProduct->find($product_id);
            $iterate = $iterate_val;

            $in = utf8_decode($product->description);
            $name_product = strlen($in) > 22 ? substr($in,0,22)."..." : $in;

//             if($iterate == 3){
// //                $initial_y = 25;
//                 $initial_y = 74.5;
//                 $espace = 27;
//             }
           if($iterate == 2){
//                $initial_y = 53;
                $initial_y = 122.5;
                $espace = 17.5;
            }
            else{
//                $initial_y = 80;
                $initial_y = 140;
                $espace = 25;
            }

            $w_logo = 20;
            $h_logo = 10;

            $empresa = $this->tenant->company();

            for($i=1; $i<=$iterate; $i++){
                for($j=1; $j<=2; $j++){
                    $code= $product->code;
                    $pdf->Code128($initial_x,$initial_y,$code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode-1.2);
                    
                    // $pdf->SetFont('Arial','B', 5.9);
                    // $pdf->SetXY($initial_x + 17.5, $initial_y-3);
                    // $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));

                    $pdf->SetFont('Arial','B',5.7);
//                $pdf->Write(5,$code);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode-1.3);
                    $pdf->Write($h_name_product,$name_product);

                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode-1.6);
                    $pdf->SetFont('Arial','B',6.5);
                    $pdf->Write($h_price_product, utf8_decode($product->code));

                    $pdf->SetFont('Arial','B', 5.9);
                    $pdf->SetXY($initial_x + 17.5, $initial_y+$h_barcode-1.55);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));

                  
        
            
                    $logo_empresa = 'default.jpg';
            
                    if ($logo_empresa != null || $logo_empresa != '') {
                        $logo_empresa = "companies/" . $empresa['url_image'];
                    }

                    $pdf->Image($logo_empresa, 40, $initial_y , $w_logo, $h_logo);

                }

                $initial_y = $initial_y + $espace;
            }

            $pdf->Output("I");
            dd("end page");
        }
        else if($ticketera == "cp_2140m"){

            $pdf->SetMargins(0,0,0,0);
            $pdf->AddPage('P', array(120.6, 152.4), 'O');
            $pdf->SetAutoPageBreak(false);

            $initial_x = 8;
            $initial_y = 30;
            $w_barcode = 28;
            $h_barcode = 9.5;

            $espace = 25;

            $h_name_product = 6;
            $h_price_product = 12;

            $product = $this->rProduct->find($product_id);
            $iterate = $iterate_val;

            $in = utf8_decode($product->description);
            $name_product = strlen($in) > 20 ? substr($in,0,20)."..." : $in;

            if($iterate == 3){
                $initial_y = 90;
                $espace = 22;
            }
            else if($iterate == 2){
                $initial_y = 112;
                $espace = 22;
            }
            else{
                $initial_y = 135;
                $espace = 0;
            }

            for($i=1; $i<=$iterate; $i++){
                for($j=1; $j<=2; $j++){
                    $code= $product->code;
                    $pdf->Code128($initial_x,$initial_y,$code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode-0.5);
                    $pdf->SetFont('Arial','B',6);
                    
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode-0.5);
                    $pdf->SetFont('Arial','B',7);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));

                    $code= $product->code;
                    $pdf->Code128($initial_x + 33,$initial_y, $code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x + 32,$initial_y+$h_barcode-0.5);
                    $pdf->SetFont('Arial','B',6);
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x + 32,$initial_y+$h_barcode-0.5);
                    $pdf->SetFont('Arial','B',7);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));

                    $code= $product->code;
                    $pdf->Code128($initial_x + 66,$initial_y, $code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x + 65,$initial_y+$h_barcode-0.5);
                    $pdf->SetFont('Arial','B',6);
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x + 65,$initial_y+$h_barcode-0.5);
                    $pdf->SetFont('Arial','B',7);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));


                }

                $initial_y = $initial_y + $espace;
            }

            $pdf->Output("I");
            dd("end page");
        }
        else{

            

            $pdf->SetMargins(0,0,0,0);
//            $pdf->AddPage('P', array(104.1, 152.4), 'O');
            $pdf->AddPage('P', array(104.1, 152.4), 'O');
            $pdf->SetAutoPageBreak(false);

//            $initial_x = 2;
            $initial_x = 4.5;
            $initial_y = 30;
            $w_barcode = 45;
            $h_barcode = 14;

            $espace = 25;

            $h_name_product = 6;
            $h_price_product = 12;

            $product = $this->rProduct->find($product_id);
            $iterate = $iterate_val;

            $in = utf8_decode($product->description);
            $name_product = strlen($in) > 35 ? substr($in,0,35)."..." : $in;

            if($iterate == 3){
//                $initial_y = 25;
                $initial_y = 74.5;
                $espace = 27;
            }
            else if($iterate == 2){
//                $initial_y = 53;
                $initial_y = 102;
                $espace = 27;
            }
            else{
//                $initial_y = 80;
                $initial_y = 130;
                $espace = 27;
            }



            for($i=1; $i<=$iterate; $i++){
                for($j=1; $j<=2; $j++){
                    $code= $product->code;
                    $pdf->Code128($initial_x,$initial_y,$code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',6);
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x-1, $initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',9);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));

                    $code= $product->code;
                    $pdf->Code128($initial_x + 54,$initial_y, $code, $w_barcode,$h_barcode);
                    $pdf->SetXY($initial_x + 53,$initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',6);
//                $pdf->Write(5,$code);
                    $pdf->Write($h_name_product,$name_product);
                    $pdf->SetXY($initial_x + 53,$initial_y+$h_barcode);
                    $pdf->SetFont('Arial','',9);
                    $pdf->Write($h_price_product, utf8_decode('S/ ' . number_format($product->price_sale, 2)));
                }

                $initial_y = $initial_y + $espace;
            }

            $pdf->Output("I");
            dd("end page");
        }
    }

    public function printNoteDocument($sale_id, $send_email = false)
    {
        $company = $this->tenant->company();
        $sale = $this->rNoteDocument->find($sale_id);
        $detail = $this->rNoteDocumentDetail->findByNote($sale['id']);
        $movement = $sale;

        $voucher = $this->rTypeVoucher->find($movement['voucher_id']);

        $client = $this->rClient->find($sale['client_id']);

        // CONFIG ONLY COMPANY NAKAES CORP | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_nakaes')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = 'nakaes_laboratorio.jpg';
                $company['tradename'] = 'LABORATORIO CLÍNICO MELGOLAB';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'nakaes_inmobiliaria.png';
                $company['tradename'] = 'NAKAES INMOBILIARIA';
                $company['email'] = 'nakaescorporacion@gmail.com';
            }
        }
        // ===========

        // CONFIG ONLY COMPANY TATOHITO AND DANIEL ALCIDES  | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_tatohito')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = 'daniel_alcides.jpeg';
                $company['address'] = 'JR. PROGRESO #304';
                $company['tradename'] = 'CLINICA DANIEL ALCIDES CARRION';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'clinica_tatohito.png';
                $company['address'] = 'JR. MARAÑON #203';
                $company['tradename'] = 'LABORATORIO CLINICO TATOHITO';
                $company['email'] = '-';
            }
        }
        // ===========

        // CONFIG ONLY COMPANY ARILITH  | DO NOT MOVE
        if ($this->tenant->database() == config('app.database_arilith')) {
            if (($movement['serie'] == 'B001') or ($movement['serie'] == 'F001')) {
                $company['url_image'] = 'agua_arilith.jpg';
                $company['address'] = 'Calle Humbolt N° 411-A - Barrio Las Flores Yurimaguas';
                $company['tradename'] = 'AGUA DE MESA ARELITH';
            } else if (($movement['serie'] == 'B002') or ($movement['serie'] == 'F002')) {
                $company['url_image'] = 'polleria_arilith.jpg';
                $company['address'] = 'Calle Las Americas #323 - Yurimaguas';
                $company['tradename'] = 'AVICOLA Y PROVEDURIA ARILITH';
                $company['email'] = '-';
            }
        }
        // ===========


        // CUSTOM TOTALES
        $total_exonerada = $sale['subtotal'];
        $total_taxed = "0.00";
        $total_gravada = "0.00";
        $title_ticket = "OP.EXONERADAS";
        if ($company->typebilling_id == config('app.billing_gravada')) {
            $total_exonerada = '0.00';
            $total_gravada =  $sale['subtotal'];
            $total_taxed = $sale['igv'];
            $title_ticket = "OP.GRAVADAS";
        }

        $document = array(
            "empresa" => $company,
//            "sucursal" => $sucursal[0],
            "venta" => $sale,
            "cliente" => $client,
            "movimiento" => $movement,
            "voucher" => $voucher,
            "totales" => array(
                "total_sale" => $sale['subtotal'],
                "total_exportation" => "0.00",
                "total_free" => "0.00",
                "total_unaffected" => "0.00",
                "total_exonerated" => $total_exonerada,
                "total_gravada" => $total_gravada,
                "total_taxed" => $total_taxed,
                "total_paid" => $sale['total'],
                "title_ticket" => $title_ticket
            ),
            "orden_compra" => '',
            "items" => $detail,
            "count_items" => count($detail)
        );


        $parameter = 'a4';
        $config_branch = $this->rBranchConfig->findByBranchoffice();
//        if ($voucher['id'] == config('app.voucher_factura_id')) {
//            $parameter = $config_branch['print_factura'];
//        }
//
//        if ($voucher['id'] == config('app.voucher_boleta_id')) {
//            $parameter = $config_branch['print_boleta'];
//        }
//
//        if ($voucher['id'] == config('app.voucher_nota_pedido_id')) {
//            $parameter = $config_branch['print_boleta'];
//        }

        if ($send_email) {
            return $this->designPdfA4($document, true);
        } else {
            if ($parameter == 'a5') {
                $this->designPdf5($document);
            } else if ($parameter == 'ticket') {
                $this->designTicket($document);
            } else {
                $this->designPdfA4NoteDocument($document);
            }
        }
    }

    public function designPdfA4NoteDocument($data, $send_email = false)
    {
        $empresa = $data['empresa'];
        $venta = $data['venta'];
        $cliente = $data['cliente'];
        $movimiento = $data['movimiento'];
        $voucher = $data['voucher'];
        $items = count($data['items']);
        $detail = $data['items'];

        $pdf = new \App\Libraries\Pdf();

        $pdf->AliasNbPages(); // para el conteo de paginas
        $pdf->SetLeftMargin(4);
        $pdf->setFillColor(249, 249, 249);
        $pdf->SetDrawColor(204, 204, 204);

        // espacios iniciales
        $ancho_total = 210;
        $height_total = 297;
        $espac = 5;
        $pos_initial_x = 5;
        $separetor_coluns = 5;
        $h_row = 3.5;
        $h_logo = 27;
        $w_logo = 47;

        $pdf->AddPage('P', 'A4');
//        $pdf->AddPage('P', array($ancho_total, $height_total));

        // CUADRADO TOTAL DE LA PAGINA
        $pdf->SetFillColor(255, 255, 255);
        $pdf->RoundedRect($pos_initial_x, $espac, $ancho_total - ($pos_initial_x + $espac), $height_total - ($pos_initial_x + $espac), 2, '1234', 'S');

        $logo_empresa = 'default.jpg';

        if ($logo_empresa != null || $logo_empresa != '') {
            $logo_empresa = "companies/" . $empresa['url_image'];
        }

        $pdf->Image($logo_empresa, $pos_initial_x + 3, $espac + 3, $w_logo, $h_logo);

        $initial_head = 15;
        $w_head = 80;


        $txt_razon_empresa = $empresa['social_reason'];
        $txt_tradename = $empresa->tradename;

        if ($txt_tradename != null or $txt_tradename != '') {

            $pdf->SetFont('Arial', 'B', 11);
            $pdf->SetY($initial_head - 5);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_tradename), 0);

            if (strlen($txt_razon_empresa) > 28) {
                $initial_head = $initial_head + $h_row - 0.5;
            }

            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(1.1 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->Cell($w_head, $h_row, utf8_decode($txt_razon_empresa), 0, 0, 'L', 1);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetY(1.4 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

            $txt_address = strtoupper(utf8_decode($empresa['address'])) . "\nTEL: " . $empresa['cellphone'] . " - " . $empresa['telephone'] . "\n" . $empresa['email'];

            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(1.7 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        } else {
            $pdf->SetFont('Arial', '', 10);
            $pdf->SetY($initial_head - 5);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 1.5, utf8_decode($txt_razon_empresa), 0);

            if (strlen($txt_razon_empresa) > 28) {
                $initial_head = $initial_head + $h_row - 0.5;
            }

            $pdf->SetFont('Arial', 'B', 11);
            $pdf->SetY(1.1 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->Cell($w_head, $h_row, utf8_decode('RUC  ' . $empresa['ruc']), 0, 0, 'L', 1);

            $txt_address = strtoupper(utf8_decode($empresa['address'])) . "\nTEL: " . $empresa['cellphone'] . " - " . $empresa['telephone'] . "\n" . $empresa['email'];

            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(1.5 * $initial_head);
            $pdf->SetX($pos_initial_x + $w_logo + $separetor_coluns);
            $pdf->MultiCell($w_head, $h_row + 0.5, $txt_address, 0);

        }

        // cuadradito para numero de factura
        $pdf->SetFillColor(245, 245, 245);
        $position_invoice_square = $pos_initial_x + $w_logo + $separetor_coluns + $w_head + $separetor_coluns;
        $w_invoice_square = $ancho_total - $position_invoice_square - 10;
        $pdf->RoundedRect($position_invoice_square, $espac + 7.5, $w_invoice_square, 25, 2, '1234', 'FD');

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($espac + 14);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($voucher['description']), 0, 0, 'C', 1);

        $pdf->SetFont('Arial', 'B', 16);
        $pdf->SetY($espac + 23);
        $pdf->SetX($position_invoice_square + 5);
        $pdf->Cell($w_invoice_square - 10, $h_row, utf8_decode($movimiento['nro_voucher']), 0, 0, 'C', 1);


        $pdf->SetFillColor(255, 255, 255);
        $pdf->SetFont('Arial', '', 9);
        $espac = $espac + $initial_head + 25;
        $fecha = date("d/m/Y", strtotime($movimiento['date_movement']));
        $hora = date("H:i:s", strtotime($movimiento['date_movement']));

        $side_r = 5;
        $w_initial = 20;
        $w_final = 125;
        $pos_x_h = $pos_initial_x + $side_r;
        $separador_row = 2;
        $space_temp = $espac;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('F. Emisión'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $fecha . '  -  ' . $hora), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $label_comprobante = $cliente->typeDocument;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode($label_comprobante), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['document']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Cliente'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final, $h_row, utf8_decode(': ' . $cliente['fullname']), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Dirección'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $cliente['address']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('*****************************************'), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('DOC. AFECTADO'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r+4);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $venta['reference_billing']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('TIPO DE NOTA'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r+4);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $venta['type_note']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('MOTIVO'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r+4);
        $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $venta['motive']), 0);

        $space_temp = $space_temp + $h_row + $separador_row;

        //**
        //TODO: REORGANIZAR CODIGO  CUANDO TODAS LAS MIGRACIONES TENGAN EL CAMPO "OBSERVATION"
        $space_table_detail = 90;
        if (isset($venta['observation'])) {
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h);
            $pdf->Cell($w_initial, $h_row, utf8_decode('Observaciones'), 0, 0, 'L', 1);
            $pdf->SetY($space_temp);
            $pdf->SetX($pos_x_h + $w_initial + $side_r);
            $pdf->MultiCell($w_final, $h_row + 0.5, utf8_decode(': ' . $venta['observation']), 0);

            $space_table_detail = 80;
        }
        //**

        $w_initial = $w_initial + 5;

        $pos_x_h = $pos_initial_x + $side_r + $w_final + $side_r;
        $w_final_col = $ancho_total - ($pos_x_h + $w_initial + $side_r) - 10;

        $space_temp = $espac;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('Condición pago'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': ' . strtoupper($this->rPaymentMethod->find($movimiento['paymentmethod_id'])['description'])), 0, 0, 'L', 1);

        $space_temp = $space_temp + $h_row + $separador_row;

        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h);
        $pdf->Cell($w_initial, $h_row, utf8_decode('N° guía remisión'), 0, 0, 'L', 1);
        $pdf->SetY($space_temp);
        $pdf->SetX($pos_x_h + $w_initial + $side_r);
        $pdf->Cell($w_final_col, $h_row, utf8_decode(': -'), 0, 0, 'L', 1);

        $espac = $espac + 2;
        $sbtotal = 0;
        $sumaIgv = 0;

        $code_leyenda = config('app.code_leyenda_bienes_exonerado');
        $txt_leyenda = config('app.txt_leyenda_bienes_exonerado');

        // detail columns
        $cols_detail = $this->get_columns_detail_a4();
        $cols_pos = array_column($cols_detail, "pos");
        $fields = array_keys($cols_detail);
        $rows = $detail;

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetFillColor(245, 245, 245);
        $pdf->SetY($space_table_detail);
        $pdf->SetX($pos_initial_x);
        $pdf->SetHeight(7);
        $pdf->SetWidths(array_column($cols_detail, 'width'));
        $pdf->Row(array_column($cols_detail, 'label'), $cols_pos, "Y", "Y", array(245, 245, 245));

        $pdf->SetHeight(5);
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetFillColor(255, 255, 255);

        if ($venta['is_grouped'] == true) {

            $row_grouped = array(
                'quantity' => 1,
                'unit' => 'NIU',
                'description' => $venta['description_grouped'],
                'price' => $venta['total'],
                'total' => $venta['total']
            );

            foreach ($rows as $row) {
                $pdf->SetX($pos_initial_x);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $sbtotal = $sbtotal + $subtotal;
            }

            $values = array();
            foreach ($fields as $field) {
                $values[] = isset($row_grouped{$field}) ? utf8_decode($row_grouped{$field}) : "";
            }

            $pdf->Row($values, $cols_pos, "Y", "Y");
        } else {
            foreach ($rows as $row) {
                $pdf->SetX($pos_initial_x);
                $product = $this->rProduct->find($row['product_id']);
                $unit = $this->rUnitMeasure->find($row['unitmeasure_id']);
                $subtotal = $row['price'] * $row['quantity'];

                if($row['igv'] != null){
                    $subtotal = ($row['price'] * $row['quantity']) + $row['igv'] ;
                }

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                $row['description'] = $product['description'];
                $row['unit'] = $unit['prefix'];
                $row['total'] = number_format($subtotal, 2);

                $values = array();
                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $sbtotal = $sbtotal + $subtotal;
                $pdf->Row($values, $cols_pos, "Y", "Y");
            }
        }


        $dataImg = array(
            $empresa['ruc'],
            $movimiento['voucher_id'],
            $movimiento['serie'],
            $movimiento['correlative'],
            $venta['total'],
            date('Y-m-d', strtotime($venta['date_sale'])),
            $cliente['typedocument_id'],
            $cliente['document'],
            ""
        );

        $pdf->SetAutoPageBreak(false);

        $initial_footer = 240;

        $pos_qr_y = $initial_footer;
        $w_qr = 40;
        $w_txt_qr = 80;


        $pdf->Line($pos_initial_x, $initial_footer - 10, $ancho_total - $side_r, $initial_footer - 10); // 20mm from each edge


        $pdf->SetFont('Arial', 'B', 7);
        $pdf->SetY($initial_footer - 7);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row, utf8_decode("Son : " . $movimiento['text_amount']), 0);

        $fileTmp = "archivos/" . $empresa['ruc'] . "-" . $movimiento['voucher_id'] . "-" . $movimiento['nro_voucher'] . ".png";

        QrCode::format('png')->size(1)->margin(0)->generate(implode("|", $dataImg), $fileTmp, QR_ECLEVEL_Q, 2, 1);

        if (file_exists($fileTmp)) {
            $imagen_qr_encode = base64_encode(file_get_contents($fileTmp));
            $pic = 'data://text/plain;base64,' . $imagen_qr_encode;
            $info = getimagesize($pic);
            unlink($fileTmp);
            $pdf->Image($pic, $pos_initial_x + $side_r, $pos_qr_y, $w_qr, $height_total - $pos_qr_y - 20, 'png');
        }

        $pdf->SetFont('Arial', '', 8);
        $pdf->SetY($pos_qr_y + ($height_total - $pos_qr_y - 20) + 3);
        $pdf->SetX($pos_initial_x + $side_r);
        $pdf->MultiCell($w_txt_qr + $w_qr - 10, $h_row + 1, utf8_decode($code_leyenda . ': ' . $txt_leyenda), 0);


        $pdf->SetFont('Arial', '', 7);
        $pdf->SetY($pos_qr_y + 2);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode('Código Hash: ' . $movimiento['billing_hash']), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 8;

        $pdf->SetFont('Arial', '', 9);
        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode("Representación impresa de"), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 1;

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode($voucher['description']), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 5;

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode("Para consultar el comprobante ingresar a:"), 0, 0, 'L', 1);

        $pos_qr_y = $pos_qr_y + $h_row + 1;

        $pdf->SetFont('Arial', 'B', 9);

        $pdf->SetY($pos_qr_y);
        $pdf->SetX($pos_initial_x + $w_qr + $side_r * 2);
        $pdf->Cell($w_txt_qr, $h_row, utf8_decode($empresa['api_facturador'] . '/buscar'), 0, 0, 'L', 1);

        $pdf->Line($w_txt_qr + $w_qr + $side_r, $initial_footer - 10, $w_txt_qr + $w_qr + $side_r, $height_total - 5); // 20mm from each edge


        $w_summary_label = 40;
        $separetor_summary = 7;
        $initial_summary = $initial_footer - 2.5;

        $pdf->SetFont('Arial', 'B', 8);

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("TOTAL VALOR DE VENTA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_sale'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

//        $pdf->SetY($initial_summary);
//        $pdf->SetX($w_txt_qr+ $w_qr+2*$side_r);
//        $pdf->Cell($w_summary_label,$h_row,utf8_decode("TOTAL DESCUENTO"),0,0,'R',1);
//        $pdf->SetX($ancho_total-$w_summary_label);
//        $pdf->Cell($ancho_total-($w_txt_qr+ $w_qr+ 2*$side_r+$w_summary_label+2*$side_r),$h_row,utf8_decode('S/ 0.00'),0,0,'R',1);
//
//        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN EXONERADA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_exonerated'], 2)), 0, 0, 'R', 1);
        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN GRAVADA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row,  utf8_decode('S/ ' . number_format($data['totales']['total_gravada'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN INAFECTA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_unaffected'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("OPERACIÓN GRATUITA"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_free'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary;

        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("IGV"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_taxed'], 2)), 0, 0, 'R', 1);

        $initial_summary = $initial_summary + $separetor_summary + 2.5;

        $total = $sbtotal + ($sumaIgv);

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetY($initial_summary);
        $pdf->SetX($w_txt_qr + $w_qr + 2 * $side_r);
        $pdf->Cell($w_summary_label, $h_row, utf8_decode("TOTAL A PAGAR"), 0, 0, 'R', 1);
        $pdf->SetX($ancho_total - $w_summary_label);
        $pdf->Cell($ancho_total - ($w_txt_qr + $w_qr + 2 * $side_r + $w_summary_label + 2 * $side_r), $h_row, utf8_decode('S/ ' . number_format($data['totales']['total_paid'], 2)), 0, 0, 'R', 1);

        if ($send_email == true) {
            $response = array(
                'pdf' => $pdf,
                'billing' => $movimiento,
            );

            return $response;
        } else {
            $pdf->Output();
        }

    }

    public function ticketVersion($data){

        $test = ['title' => 'coding driver test title'];

        $pdf = PDF::loadView('invoices.ticket_billing', $test);
//        $SIZE_PAPER = array(0,0,73, 50);
        $SIZE_PAPER = array(0,0,73.70,100);


        $pdf->setPaper($SIZE_PAPER, "portrait");

        return $pdf->stream('codingdriver.pdf');
    }

}
