<?php

namespace App\Http\Controllers;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Proforma\ProformaRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;

class MailController extends Controller
{

    protected $utilHelper;
    protected $tenant;
    protected $generateDocument;
    protected $rProforma;
    protected $rClient;
    protected $rMovement;
    protected $rSale;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->tenant = new TenantCore();
        $this->generateDocument = new GenerateDocumentPdf();
        $this->rProforma = new ProformaRepository();
        $this->rMovement = new MovementRepository();
        $this->rSale = new SaleRepository();
        $this->rClient = new ClientRepository();
    }

    public function sendEmailBilling(Request $request, $sale_id){
        $data = $this->generateDocument->printBilling($sale_id, true);
        $pdf = $data['pdf'];
        $billing = $data['billing'];

        $name_pdf = "comprobante_electronico.pdf";
        $pdf->output('F','archivos/'.$name_pdf);
        $company = $this->tenant->company();
        $sale = $this->rSale->find($sale_id);
        $client = $this->rClient->find($sale['client_id']);
        $email_send = $request->get('email');

        if (filter_var($email_send, FILTER_VALIDATE_EMAIL)) {

            $file_document ="archivos/".$name_pdf;
            $data = array(
                'company'=>$company,
                'billing'=>$billing,
                'client'=>$client,
            );

            Mail::send('emails.mail_billing', $data, function($message) use ($email_send, $company, $billing, $file_document) {
                $message->to($email_send, 'Correo')->subject('ENVÍO COMPROBANTE ELECTRÓNICO '.$billing['nro_voucher']);
                $message->attach($file_document);
                $message->from('sisturing@gmail.com','sisturing.com');
            });

            unlink($file_document);

            $response = array(
                'status' => 'success',
                'msg' => 'El correo ha sido enviado correctamente '
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } else {
            throw new \ErrorException($email_send.' no es un correo de formato válido');
        }

    }

    public function sendEmailProforma(Request $request, $proforma_id)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $pdf = $this->generateDocument->printProformaDocument($proforma_id, true);
            $name_pdf = "cotizacion.pdf";
            $pdf->output('F','archivos/'.$name_pdf);

            $company = $this->tenant->company();
            $proforma = $this->rProforma->find($proforma_id);
            $client = $this->rClient->find($proforma['client_id']);
            $email_send = $request->get('email');

            if (filter_var($email_send, FILTER_VALIDATE_EMAIL)) {

                $file_document ="archivos/".$name_pdf;
                $data = array(
                    'company'=>$company,
                    'proforma'=>$proforma,
                    'client'=>$client,
                );

                Mail::send('emails.mail_proforma', $data, function($message) use ($email_send, $company, $proforma, $file_document) {
                    $message->to($email_send, 'Correo')->subject('ENVÍO SOLICITUD COTIZACIÓN '.$proforma['nro_voucher']);
                    $message->attach($file_document);
                    $message->from('sisturing@gmail.com','SISTURING SUPPORT');
                    // $message->from('sisturing@gmail.com','sisturing.com');
                });

                unlink($file_document);

                $response = array(
                    'status' => 'success',
                    'msg' => 'El correo ha sido enviado correctamente!!'
                );

                DB::connection('tenant')->commit();
                return response()->json($response);

            } else {
                throw new \ErrorException($email_send.' no es un correo de formato válido');
            }

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }

    }

}
