<?php

namespace App\Http\Controllers\System;

use App\Http\Controllers\Controller;
use App\Models\System\Activation\ActivationRepository;
use App\Models\System\Company\CompanyRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ActivationsController extends Controller
{

    protected $rActivation;
    protected $rCompany;

    public function __construct()
    {
        $this->rActivation = new ActivationRepository();
        $this->rCompany = new CompanyRepository();
    }


    public function index()
    {
        $items = $this->rActivation->all();
        return view('system.activations', compact('items'));
    }


    public function create()
    {
        $is_create = true;
        $companies = $this->rCompany->all();
        return view('system.activation.new', compact('is_create','companies'));
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();
            $validator = Validator::make($request->all(), [
                'date_start' => 'required',
                'date_end' => 'required',
//                'date_end' => 'required',
            ]);

            if ($validator->fails()) {
                return back()
                    ->withErrors($validator)
                    ->withInput();
            }


            // save item
            $this->rActivation->create($data);

            DB::commit();
            return redirect()->route('system.activations');

        } catch (\Exception $e) {
            DB::rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $is_create = false;
        $companies = $this->rCompany->all();
        $item = $this->rActivation->find($id);
        return view("system.activation.new", compact('is_create', 'item', 'companies'));
    }


    public function update(Request $request, $id)
    {
        $data = $request->all();
        $this->rActivation->updated($id, $data);
        return redirect()->route('system.activations');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
