<?php

namespace App\Http\Controllers\System;

use App\Http\Controllers\Controller;
use App\Models\System\CategoryCompany\CategoryCompanyRepository;
use App\Models\System\Company\CompanyRepository;
use App\Models\System\Plan\PlanRepository;
use Hyn\Tenancy\Models\Hostname;
use Hyn\Tenancy\Models\Website;
use Hyn\Tenancy\Repositories\HostnameRepository;
use Hyn\Tenancy\Repositories\WebsiteRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

// tenancy

class CompanyController extends Controller
{

    protected $rCompany;
    protected $rCategorieCompany;
    protected $rPlan;

    public function __construct()
    {
        $this->rCompany = new CompanyRepository();
        $this->rCategorieCompany = new CategoryCompanyRepository();
        $this->rPlan = new PlanRepository();
    }

    public function index()
    {
        $items = $this->rCompany->allCompany();
        return view('system.company', compact('items'));
    }


    public function create()
    {
        $domain = config('app.domain');
        $categories = $this->rCategorieCompany->all();
        $plans = $this->rPlan->all();
        return view('system.company.new', compact('domain', 'categories', 'plans'));
    }


    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();

            $validator = Validator::make($request->all(), [
                'social_reason' => 'required',
                'ruc' => 'required',
                'hostname' => 'required',
                'url_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);

            if ($validator->fails()) {
                return back()
                    ->withErrors($validator)
                    ->withInput();
            }

            $fqdn = sprintf('%s.%s', $data['hostname'], config('app.domain'));
            $website = new Website;
            $website->uuid = Str::random(10);
            app(WebsiteRepository::class)->create($website);
            $hostname = new Hostname();
            $hostname->fqdn = $fqdn;
            $hostname = app(HostnameRepository::class)->create($hostname);
            app(HostnameRepository::class)->attach($hostname, $website);

            // add company row
            $data['website_id'] = $website->id;
            $company = $this->rCompany->create($data);

            if ($request->hasFile('url_image')) {
                $image = $request->file('url_image');
                $name = $company['ruc'].'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/companies');
                $image->move($destinationPath, $name);
                $company->url_image = $name;
            }else{
                $company->url_image = 'default.jpg';
            }
            $company->save();

            return redirect()->route('system.company');

            DB::commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
