<?php

namespace App\Http\Controllers\System;

use App\Http\Controllers\Controller;
use App\Models\System\Plan\PlanRepository;
use App\Models\System\PlanDetail\PlanDetailRepository;
use App\Models\System\System\Module\ModuleRepository;
use App\Models\System\System\ModuleProfile\ModuleProfileRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

class PlansController extends Controller
{

    protected $rModule;
    protected $rPlan;
    protected $rPlanDetail;
    protected $rModuleProfile;

    public function __construct()
    {
        $this->rModule = new ModuleRepository();
        $this->rPlan = new PlanRepository();
        $this->rPlanDetail = new PlanDetailRepository();
        $this->rModuleProfile = new ModuleProfileRepository();
    }

    public function index()
    {
        $items = $this->rPlan->all();
        return view('system.plans', compact('items'));

    }


    public function create()
    {
        $is_create = true;
        return view('system.plan.new', compact('is_create'));
    }


    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();
            $validator = Validator::make($request->all(), [
                'description' => 'required',
            ]);

            if ($validator->fails()) {
                return back()
                    ->withErrors($validator)
                    ->withInput();
            }

            // save item
            $this->rPlan->create($data);

            DB::commit();
            return redirect()->route('system.plans');

        } catch (\Exception $e) {
            DB::rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $is_create = false;
        $item = $this->rPlan->find($id);
        return view("system.plan.new", compact('is_create','item'));
    }

    public function update(Request $request, $id)
    {
        $data = $request->all();
        $this->rPlan->updated($id, $data);
        return redirect()->route('system.plans');
    }

    public function modulesByPlan($plan_id)
    {
        $query = $this->rModule->allByPlanId($plan_id);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function assingModules($id)
    {
        $is_create = false;
        $plan = $this->rPlan->find($id);
        $modules = $this->rModule->allModules();
        return view("system.plan.assingmodules", compact('is_create','plan', 'modules'));
    }

    public function assingModulesSave(Request $request, $id)
    {
        $data = $request->all();
        if(isset($data['module_assing']) == false){
            session()->flash('msg', 'DEBE ASSIGNAR AL MENOS UN MÓDULO AL PLAN EMPRESARIAL');
            return Redirect::back();
        }

        $modules_assing = $data['module_assing'];
        $plan_id = $data['plan_id'];

        $detail_pass = $this->rPlanDetail->listByPlan($plan_id);

        foreach ($detail_pass as $item){
            $this->rPlanDetail->deleted($item->id);
        }

        foreach ($modules_assing as $module) {
            $item = $this->rPlanDetail->findByPlanAndModule($plan_id, $module);
            if($item == null){
                $register = array();
                $register['module_id'] = $module;
                $register['plan_id'] = $plan_id;

                $this->rPlanDetail->create($register);
            }
            else{
                $item->deleted_at = null;
                $item->save();
            }
        }

        return redirect()->route('system.plans');
    }


    public function destroy($id)
    {
        $this->rPlan->deleted($id);
        return Redirect::back();
    }
}
