<?php

namespace App\Http\Controllers\System;

use App\Http\Controllers\Controller;
use App\Models\System\System\Module\ModuleRepository;
use App\Models\System\System\ModulePermission\ModulePermissionRepository;
use App\Models\System\System\ModuleProfile\ModuleProfileRepository;
use App\Models\System\System\PermissionProfile\PermissionProfileRepository;
use App\Models\System\UserProfile\UserProfileRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

class ProfileController extends Controller
{

    protected $rUserProfile;
    protected $rModule;
    protected $rModuleProfile;
    protected $rModulePermission;
    protected $rPermissionProfile;

    public function __construct()
    {
        $this->rUserProfile = new UserProfileRepository();
        $this->rModule = new ModuleRepository();
        $this->rModuleProfile = new ModuleProfileRepository();
        $this->rModulePermission = new ModulePermissionRepository();
        $this->rPermissionProfile = new PermissionProfileRepository();
    }

    public function index()
    {
        $items = $this->rUserProfile->all();
        return view('system.userprofile', compact('items'));
    }


    public function create()
    {
        $is_create = true;
        return view('system.profile.new', compact('is_create'));
    }


    public function store(Request $request)
    {

        DB::beginTransaction();
        try {
            $data = $request->all();
            $validator = Validator::make($request->all(), [
                'description' => 'required',
            ]);

            if ($validator->fails()) {
                return back()
                    ->withErrors($validator)
                    ->withInput();
            }

            // save item
            $this->rUserProfile->create($data);

            DB::commit();
            return redirect()->route('system.profiles');

        } catch (\Exception $e) {
            DB::rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {

    }

    public function edit($id)
    {
        $is_create = false;
        $item = $this->rUserProfile->find($id);
        return view("system.profile.new", compact('is_create','item'));
    }

    public function modulesByProfile($profile_id)
    {
        $query = $this->rModule->allByProfileId($profile_id);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function permissionsByProfile($profile_id)
    {
        $query = $this->rPermissionProfile->allByProfileId($profile_id);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function update(Request $request, $id)
    {
        $data = $request->all();
        $this->rUserProfile->updated($id, $data);
        return redirect()->route('system.profiles');
    }

    public function assingModules($id)
    {
        $is_create = false;
        $profile = $this->rUserProfile->find($id);
        $modules = $this->rModule->allModules();
        return view("system.profile.assingmodules", compact('is_create','profile', 'modules'));
    }

    public function assingModulesSave(Request $request, $id)
    {
        $data = $request->all();
        if(isset($data['module_assing']) == false){
            session()->flash('msg', 'DEBE ASSIGNAR AL MENOS UN MÓDULO AL PERFIL');
            return Redirect::back();
        }

        $modules_assing = $data['module_assing'];
        $profile_id = $data['profile_id'];

        $detail_pass = $this->rModuleProfile->listByProfile($profile_id);

        foreach ($detail_pass as $item){
            $this->rModuleProfile->deleted($item->id);
        }

        foreach ($modules_assing as $module) {
            $item = $this->rModuleProfile->findByProfileAndModule($profile_id, $module);
            if($item == null){
                $register = array();
                $register['module_id'] = $module;
                $register['profile_id'] = $profile_id;

                $this->rModuleProfile->create($register);
            }
            else{
                $item->deleted_at = null;
                $item->save();
            }
        }

//        $this->rUserProfile->updated($id, $data);
        return redirect()->route('system.profiles');
    }


    public function assingPermissions($id)
    {
        $is_create = false;
        $profile = $this->rUserProfile->find($id);
        $modules = $this->rModule->allModules();
        return view("system.profile.assingpermissions", compact('is_create','profile', 'modules'));
    }

    public function assingPermissionsSave(Request $request, $id)
    {
        $data = $request->all();
        if(isset($data['module_assing']) == false){
            session()->flash('msg', 'DEBE ASSIGNAR AL MENOS UN MÓDULO AL PERFIL');
            return Redirect::back();
        }

        $modules_assing = $data['module_assing'];
        $profile_id = $data['profile_id'];

        $detail_pass = $this->rPermissionProfile->listByProfile($profile_id);

        foreach ($detail_pass as $item){
            $this->rPermissionProfile->deleted($item->id);
        }

        foreach ($modules_assing as $module) {
            $item = $this->rPermissionProfile->findByProfileAndModule($profile_id, $module);
            if($item == null){
                $register = array();
                $register['modulepermission_id'] = $module;
                $register['moduleprofile_id'] = $profile_id;
                $this->rPermissionProfile->create($register);
            }
            else{
                $item->deleted_at = null;
                $item->is_show = true;
                $item->save();
            }
        }

//        $this->rUserProfile->updated($id, $data);
        return redirect()->route('system.profiles');
    }


    public function destroy($id)
    {
        $this->rUserProfile->deleted($id);
        return Redirect::back();
    }
}
