<?php

namespace App\Http\Controllers;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Models\System\System\Module\ModuleRepository;
use App\Models\Tenant\Branch\BranchBoxes\BranchBoxesRepository;
use App\Models\Tenant\Branch\BranchConfig\BranchConfigRepository;
use App\Models\Tenant\Branch\BranchOffice\BranchOfficeRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class TenantController extends Controller
{
    protected $rModule;
    protected $rBranchOffice;
    protected $rBranchConfig;
    protected $utilHelper;
    protected $tenant;

    protected $rBranchBox;

    public function __construct()
    {
        $this->rModule = new ModuleRepository();
        $this->rBranchOffice = new BranchOfficeRepository();
        $this->rBranchConfig = new BranchConfigRepository();
        $this->utilHelper = new UtilHelper();
        $this->tenant = new TenantCore();

        $this->rBranchBox = new BranchBoxesRepository();
    }

    public function index()
    {
        return redirect()->route('tenant.company.branchoffice');
    }

    public function branchoffice()
    {
        $branchs = $this->rBranchOffice->allByUser();
        $this->removeSession();
        if ($this->validIsMaintenance() === true) {
            return view('tenant.company', compact('branchs'));
        } else {
            return view("maintenance");
        }
    }

    private function removeSession(){
        Session::remove('branchoffice_id');
        Session::remove('branchbox_id');
    }

    public function selectBranchOffice(Request $request){
        $data = $request->all();
        $branch = Session::put('branchoffice_id', $data['branchoffice_id']);
        return redirect()->route('tenant.sisturing');
    }

    protected function validIsMaintenance()
    {
//        if (config('app.is_maintenance') === true) {
//            return false;
//        }
//
//        if ($this->tenant->hostname()->is_maintenance === true) {
//            return false;
//        }
        return true;
    }


    public function sisturing()
    {
//        if ($this->validIsMaintenance() === true) {
//            $company = $this->tenant->company();
//            $modules = $this->rModule->allJoinedCompany($company);
//            $config = $this->rBranchConfig->findByBranchoffice();
//            $branchoffice = $this->rBranchOffice->find($this->utilHelper->getBranchOffice());
//            $boxmoney = $this->rBranchBox->find(Session::get('branchbox_id'));
//            return view('base.base_admin', compact('modules', 'config', 'branchoffice', 'boxmoney'));
//
//        } else {
//            return view("maintenance");
//        }
        $company = $this->tenant->company();
        $modules = $this->rModule->allJoinedCompany($company);
        $config = $this->rBranchConfig->findByBranchoffice();
        $branchoffice = $this->rBranchOffice->find($this->utilHelper->getBranchOffice());
//        $boxmoney = $this->rBranchBox->find(Session::get('branchbox_id'));
        return view('base.base_admin', compact('modules', 'config', 'branchoffice'));
//        return view('base.base_admin', compact('modules', 'config', 'branchoffice', 'boxmoney'));

    }

    public function changeTheme($theme)
    {
        $config = $this->rBranchConfig->findByBranchoffice();
        // CHANGE THEME
        $this->rBranchConfig->changeTheme($config->id, $theme);
        return redirect()->back();
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
