<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Session;

class BranchofficeMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (!Session::has('branchoffice_id')) {
            session()->flash('msg', 'Por favor seleccione una sucursal para poder ingresar al control del sistema!!');
            return redirect()->route('tenant.company.branchoffice');
        }

        return $next($request);
    }
}
