<?php


namespace App\Models\System\Activation;


use App\Models\Contract\BaseRepositoryInterface;

class ActivationRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new Activation();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new Activation();
        $item->company_id = $attributes['company_id'];
        $item->date_start = $attributes['date_start'];
        $item->date_end = $attributes['date_end'];
        $item->amount = $attributes['amount'];
        $item->observation = $attributes['observation'];
        $item->is_active = true;
        $item->save();
        return $item;

    }

        public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->company_id = $attributes['company_id'];
        $item->date_start = $attributes['date_start'];
        $item->date_end = $attributes['date_end'];
        $item->amount = $attributes['amount'];
        $item->observation = $attributes['observation'];
        $item->is_active = $attributes['is_active'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
