<?php

namespace App\Models\System\Company;

use App\Core\ModelsCore;
use App\Models\System\Plan\PlanRepository;
use Hyn\Tenancy\Traits\UsesSystemConnection;
use Illuminate\Database\Eloquent\Model;

class Company extends ModelsCore
{
    use UsesSystemConnection;

    protected $table = 'companies';

    protected $appends = ["urlImageBase", "plan", "name_complete"];

    public function getnameCompleteAttribute()
    {
        $name_complete = 'RUC : '.$this->attributes['ruc'].' - '.$this->attributes['social_reason'];
        return $name_complete;
    }


    public function getplanAttribute()
    {
        if (isset($this->attributes['plan_id'])) {
            $plan = new PlanRepository();
            $data = $plan->find($this->attributes['plan_id']);
            return $data['description'];
        }
    }

    public function geturlImageBaseAttribute()
    {
        if (isset($this->attributes['url_image'])) {
            $base64 = null;
            $url_image = $this->attributes['url_image'];
            $path = "companies/".$url_image;
            if (file_exists(public_path($path))){
                $type = pathinfo($path, PATHINFO_EXTENSION);
                $data = file_get_contents($path);
                $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
            }

            return $base64;
        }
    }


}
