<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 18/06/2020
 * Time: 05:35 PM
 */

namespace App\Models\System\Company;


use App\Models\Contract\BaseRepositoryInterface;

class CompanyRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new Company();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allCompany()
    {
        $model = $this->model();

        $data = $model
            ->join('websites', 'companies.website_id', '=', 'websites.id')
            ->join('hostnames', 'hostnames.website_id', '=', 'websites.id')
            ->select('companies.*', 'hostnames.fqdn as domain')
            ->where('companies.deleted_at', null)
            ->orderBy("companies.id", "ASC")
            ->get();

        return $data;
    }

    public function create(array $attributes)
    {
        $item = new Company();
        $item->website_id = $attributes['website_id'];
        $item->category_id = $attributes['category_id'];
        $item->plan_id = $attributes['plan_id'];
        $item->tradename = $attributes['tradename'];
        $item->social_reason = $attributes['social_reason'];
        $item->ruc = $attributes['ruc'];
        $item->address = $attributes['address'];
        $item->ubigeo = $attributes['ubigeo'];
        $item->cellphone = $attributes['cellphone'];
        $item->telephone = $attributes['telephone'];
        $item->email = $attributes['email'];
        $item->api_facturador = $attributes['api_facturador'];
        $item->api_token = $attributes['api_token'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->tradename = $attributes['tradename'];
        $item->address = $attributes['address'];
        $item->cellphone = $attributes['cellphone'];
        $item->telephone = $attributes['telephone'];
        $item->activity_description = $attributes['activity_description'];
        $item->offers_description = $attributes['offers_description'];
        $item->email = $attributes['email'];
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function saveUrlImage($item, $attributes)
    {
        $last_image = $item['url_image'];
        $route_last_image = "companies/".$item['url_image'];
        $image = $attributes['url_image'];
        if ($image != null) {
            $file_url = $this->saveUrlImgCompany($attributes);
            $item->url_image = $file_url;
            $item->save();

//            if($last_image != "default.jpg"){
//                if (file_exists(public_path($route_last_image))){
//                    unlink($route_last_image);
//                }
//            }

        }
    }

    public function saveUrlImgCompany($data){

        $image = $data['url_image'];
        $document = $data['ruc'];

        $imageInfo = explode(";base64,", $image);
        $imgExt = str_replace('data:image/', '', $imageInfo[0]);
        $image = str_replace(' ', '+', $imageInfo[1]);

//        $imageName = $document.".".$imgExt;
        $imageName = $document."."."png";
        $path =  public_path('/companies/');

        // save image format png
        $this->saveImagePng($path, $imageName, $image);
        return $imageName;
    }

    function saveImagePng($path, $name_img, $base64_string){
        $im = base64_decode($base64_string);
        $filename = $path;
        $filename .= $name_img;

        $file = fopen($filename, "wb");
        $newIamge = $this->resize_image($im, 280, 230);
        fwrite($file, $newIamge);
        fclose($file);
        return $filename;
    }

    function resize_image($file, $w, $h, $crop=FALSE) {
        $src = imagecreatefromstring($file);
        if (!$src) return false;
        $width = imagesx($src);
        $height = imagesy($src);

        $r = $width / $height;
        if ($crop) {
            if ($width > $height) {
                $width = ceil($width-($width*abs($r-$w/$h)));
            } else {
                $height = ceil($height-($height*abs($r-$w/$h)));
            }
            $newwidth = $w;
            $newheight = $h;
        } else {
            if ($w/$h > $r) {
                $newwidth = $h*$r;
                $newheight = $h;
            } else {
                $newheight = $w/$r;
                $newwidth = $w;
            }
        }
        //$src = imagecreatefrompng($file);
        $dst = imagecreatetruecolor($newwidth, $newheight);
        imagecopyresampled($dst, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

        // Buffering
        ob_start();
        imagepng($dst);
        $data = ob_get_contents();
        ob_end_clean();
        return $data;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findByWebsite($website)
    {
        return $this->obj->where('website_id',$website)->first();
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}