<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 05/08/2020
 * Time: 12:29 AM
 */

namespace App\Models\System\Plan;

use App\Models\Contract\BaseRepositoryInterface;

class PlanRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new Plan();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new Plan();
        $item->description = strtoupper($attributes['description']);
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->description = strtoupper($attributes['description']);
        $item->save();
        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}