<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 03/09/2020
 * Time: 11:46 PM
 */

namespace App\Models\System\PlanDetail;


use App\Models\Contract\BaseRepositoryInterface;

class PlanDetailRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new PlanDetail();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listByPlan($plan_id)
    {
        $query = $this->obj
            ->where('plan_id', $plan_id)
            ->get();

        return $query;
    }

    public function create(array $attributes)
    {
        $item = new PlanDetail();
        $item->module_id = $attributes['module_id'];
        $item->plan_id = $attributes['plan_id'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByPlanAndModule($plan_id, $module_id)
    {
        $query = $this->obj
            ->where('plan_id', $plan_id)
            ->where('module_id', $module_id)
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}