<?php

namespace App\Models\System\System\Module;

use App\Core\ModelsCore;
use App\Core\TenantCore;
use App\Models\System\System\ModulePermission\ModulePermissionRepository;

class Module extends ModelsCore
{
    protected $table = 'system_modules';

    protected $appends = ["childs","isParent", "childsmodule", "modulepermissions"];


    public function getchildsAttribute()
    {
        $childs = [];
        if ($this->attributes['id']) {

            $hostname = app(\Hyn\Tenancy\Environment::class)->hostname();
            if ($hostname) {
                $tenant = new TenantCore();
                $company = $tenant->company();
                $user = auth()->user();
                if ($user->is_superadmin) {
                    $childs = $this
                        ->join('plan_detailplans', 'plan_detailplans.module_id', '=', 'system_modules.id')
                        ->where("father_id", $this->attributes['id'])
                        ->select('system_modules.*')
                        ->where('plan_detailplans.plan_id', $company->plan_id)
                        ->where('system_modules.is_show', true)
                        ->where('plan_detailplans.deleted_at', null)
                        ->orderBy('system_modules.position', 'ASC')
                        ->get();
                } else {
                    $childs = $this
                        ->join('system_moduleprofiles', 'system_modules.id', '=', 'system_moduleprofiles.module_id')
                        ->join('plan_detailplans', 'system_modules.id', '=', 'plan_detailplans.module_id')
                        ->select('system_modules.*')
                        ->where('system_moduleprofiles.profile_id', $user->profile_id)
                        ->where('plan_detailplans.plan_id', $company->plan_id)
                        ->where('system_modules.father_id', $this->attributes['id'])
                        ->where('plan_detailplans.deleted_at', null)
                        ->where('system_moduleprofiles.deleted_at', null)
                        ->where('system_modules.is_show', true)
                        ->orderBy('system_modules.position', 'ASC')
                        ->get();
                }
            }
        }
        return $childs;
    }

    public function getchildsmoduleAttribute()
    {
        $childs = [];
        if ($this->attributes['id']) {
            $childs = $this
                ->select('system_modules.*')
                ->where('system_modules.father_id', $this->attributes['id'])
                ->where('is_show', true)
                ->orderBy('position', 'ASC')
                ->get();
        }
        return $childs;
    }


    public function getisParentAttribute()
    {
        $is_parent = false;
        if ($this->attributes['ui_sref'] == '#') {
            $is_parent = true;
        }
        return $is_parent;
    }


    public function getmodulePermissionsAttribute()
    {
        $permissions = [];
        if ($this->attributes['id']) {
            $rModulePermission = new ModulePermissionRepository();
            $permissions = $rModulePermission->allByModule($this->attributes['id']);
        }
        return $permissions;
    }



}
