<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 18/06/2020
 * Time: 11:24 AM
 */

namespace App\Models\System\System\Module;


use App\Models\Contract\BaseRepositoryInterface;
use App\Models\System\System\ModuleProfile\ModuleProfileRepository;

class ModuleRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $rModuleProfile;

    public function __construct()
    {
        $this->obj = new Module();
        $this->rModuleProfile = new ModuleProfileRepository();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allModulesForPermissions()
    {
        return $this->obj
            ->where('is_show', true)
            ->get();
    }

    public function allModules()
    {
        return $this->obj
            ->where('father_url', '!=', null)
            ->where('is_show', true)
            ->get();
    }

    public function allByProfile()
    {
        $model = $this->model();
        $user = auth()->user();

        if ($user->is_superadmin) {
            $data = $this->allModules();
        } else {
            $data = $model
                ->join('system_moduleprofiles', 'system_moduleprofiles.module_id', '=', 'system_modules.id')
                ->join('user_profiles', 'system_moduleprofiles.profile_id', '=', 'user_profiles.id')
                ->select('system_modules.*')
                ->where('system_moduleprofiles.profile_id', $user->profile_id)
                ->where('system_modules.father_url', '!=', null)
                ->where('system_modules.is_show', true)
                ->get();

        }
        return $data;
    }


    public function allJoinedCompany($company)
    {
        $model = $this->model();
        $user = auth()->user();
        if ($user->is_superadmin) {
//            $data = $this->allModules();
            $data = $this->obj
                ->join('plan_detailplans', 'plan_detailplans.module_id', '=', 'system_modules.id')
                ->select('system_modules.*')
                ->where('plan_detailplans.plan_id', $company->plan_id)
                ->where('system_modules.is_show', true)
                ->where('plan_detailplans.deleted_at', null)
                ->whereRaw('system_modules.father_id ISNULL')
                ->where('system_modules.is_show', true)
                ->orderBy('system_modules.position', 'ASC')
                ->get();

        } else {
            $data = $model
                ->join('system_moduleprofiles', 'system_modules.id', '=', 'system_moduleprofiles.module_id')
                ->join('plan_detailplans', 'system_modules.id', '=', 'plan_detailplans.module_id')
                ->select('system_modules.*')
                ->where('plan_detailplans.plan_id', $company->plan_id)
                ->where('system_moduleprofiles.profile_id', $user->profile_id)
                ->whereRaw('system_modules.father_id ISNULL')
                ->where('plan_detailplans.deleted_at', null)
                ->where('system_moduleprofiles.deleted_at', null)
                ->where('system_modules.is_show', true)
                ->orderBy('system_modules.position', 'ASC')
                ->get();

        }
        return $data;
    }

    public function allByProfileId($profile_id)
    {
        $data = $this->obj
            ->join('system_moduleprofiles', 'system_moduleprofiles.module_id', '=', 'system_modules.id')
            ->join('user_profiles', 'system_moduleprofiles.profile_id', '=', 'user_profiles.id')
            ->select('system_modules.*')
            ->where('system_moduleprofiles.profile_id', $profile_id)
            ->where('system_modules.is_show', true)
            ->where('system_moduleprofiles.deleted_at', null)
            ->get();
        return $data;
    }

    public function allByPlanId($plan_id)
    {
        $data = $this->obj
            ->join('plan_detailplans', 'plan_detailplans.module_id', '=', 'system_modules.id')
            ->select('system_modules.*')
            ->where('plan_detailplans.plan_id', $plan_id)
            ->where('system_modules.is_show', true)
            ->where('plan_detailplans.deleted_at', null)
            ->get();
        return $data;
    }


    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
