<?php


namespace App\Models\System\System\ModulePermission;


use App\Core\TenantCore;
use App\Models\Contract\BaseRepositoryInterface;

class ModulePermissionRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $tenant;

    public function __construct()
    {
        $this->obj = new ModulePermission();
        $this->tenant = new TenantCore();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allByModule($module_id)
    {
        return $this->obj
            ->where('module_id', '=', $module_id)
            ->where('is_show', true)
            ->get();
    }

    public function permissions()
    {

        $company = $this->tenant->company();



        if($company->control_permissions){
            $data = $this->obj
                ->leftjoin('system_permissionsprofile', 'system_permissionsprofile.modulepermission_id', '=', 'system_modulepermissions.id')
                ->selectRaw('system_modulepermissions.id,
                    system_modulepermissions.module_id,
                    system_modulepermissions.description,
                    system_modulepermissions.code,
                    system_modulepermissions.action,
                    system_permissionsprofile.is_show as is_show')
                ->where('system_permissionsprofile.moduleprofile_id', auth()->user()->profile_id)
                ->get();
        } else{
            $data = $this->obj
                ->leftjoin('system_permissionsprofile', 'system_permissionsprofile.modulepermission_id', '=', 'system_modulepermissions.id')
                ->selectRaw('system_modulepermissions.id,
                    system_modulepermissions.module_id,
                    system_modulepermissions.description,
                    system_modulepermissions.code,
                    system_modulepermissions.action,
                    system_modulepermissions.is_show as is_show')
//                ->where('system_permissionsprofile.moduleprofile_id', auth()->user()->profile_id)
                ->get();
        }

        return $data;

//        $arr_permissions = array(
//            array(
//                'code' => 'sales_sale_create',
//                'action' => 'hidden',
//                'is_show' => true
//            ),
//            array(
//                'code' => 'sales_sale_export',
//                'action' => 'disabled',
//                'is_show' => false
//            ),
//            array(
//                'code' => 'sales_sale_editprice',
//                'action' => 'disabled',
//                'is_show' => false
//            )
////            'sales_sale_create',
////            'sales_sale_editprice'
//        );
//
//        return $arr_permissions;
    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
