<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 01/07/2020
 * Time: 03:20 PM
 */

namespace App\Models\System\System\ModuleProfile;

use App\Models\Contract\BaseRepositoryInterface;

class ModuleProfileRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new ModuleProfile();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ModuleProfile();
        $item->module_id = $attributes['module_id'];
        $item->profile_id = $attributes['profile_id'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function listByProfile($profile_id)
    {
        $query = $this->obj
            ->where('profile_id', $profile_id)
            ->get();

        return $query;
    }

    public function findByProfileAndModule($profile_id, $module_id)
    {
        $query = $this->obj
            ->where('profile_id', $profile_id)
            ->where('module_id', $module_id)
            ->first();

        return $query;
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}