<?php


namespace App\Models\System\System\PermissionProfile;


use App\Models\Contract\BaseRepositoryInterface;

class PermissionProfileRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new PermissionProfile();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allByProfileId($profile_id)
    {
        $data = $this->obj
            ->join('system_modulepermissions', 'system_permissionsprofile.modulepermission_id', '=', 'system_modulepermissions.id')
            ->select('system_modulepermissions.*')
            ->where('system_permissionsprofile.moduleprofile_id', $profile_id)
            ->where('system_permissionsprofile.is_show', true)
            ->where('system_permissionsprofile.deleted_at', null)
            ->get();
        return $data;

    }

    public function listByProfile($profile_id)
    {
        $query = $this->obj
            ->where('moduleprofile_id', $profile_id)
            ->get();

        return $query;
    }

    public function create(array $attributes)
    {
        $item = new PermissionProfile();
        $item->modulepermission_id = $attributes['modulepermission_id'];
        $item->moduleprofile_id = $attributes['moduleprofile_id'];
        $item->is_show = true;
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function findByProfileAndModule($profile_id, $modulepermission_id)
    {
        $query = $this->obj
            ->where('moduleprofile_id', $profile_id)
            ->where('modulepermission_id', $modulepermission_id)
            ->first();

        return $query;
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->is_show = false;

        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
