<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 02/09/2020
 * Time: 02:23 AM
 */

namespace App\Models\System\UserProfile;

use App\Models\Contract\BaseRepositoryInterface;

class UserProfileRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new UserProfile();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new UserProfile();
        $item->description = strtoupper($attributes['description']);
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->description = strtoupper($attributes['description']);
        $item->save();
        return $item;
    }

//    public function updated($id, array $attributes)
//    {
//        $item = $this->obj->find($id);
//        $item->description = strtoupper($attributes['description']);
//        $item->save();
//        return $item;
//    }


    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}