<?php

namespace App\Models\Tenant\Billing\NoteDocument;

use App\Core\ModelsCore;
use App\Models\Tenant\Config\BillingCode\BillingCodeRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class NoteDocument extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'billing_notedocuments';


    protected $appends = ["reference_billing", "type_note"];

    public function getreferenceBillingAttribute()
    {
        if (isset($this->attributes['movement_id'])) {
            $movement = new MovementRepository();
            $reference_billing = $movement->find($this->attributes['movement_id']);
            return $reference_billing['nro_voucher'];
        }
    }

    public function gettypeNoteAttribute()
    {
        if (isset($this->attributes['billingcode_id'])) {
            $config = new BillingCodeRepository();
            $reference_billing = $config->find($this->attributes['billingcode_id']);
            return $reference_billing['description'];
        }
    }


}
