<?php


namespace App\Models\Tenant\Billing\NoteDocument;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class NoteDocumentRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new NoteDocument();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listNoteDocuments($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $model
            ->join('sale_clients', 'billing_notedocuments.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->join('config_typevoucher', 'billing_notedocuments.voucher_id', '=', 'config_typevoucher.id')
            ->selectRaw(
                "billing_notedocuments.*,
                DATE(billing_notedocuments.date_document) as date_document,
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                config_typedocument.description as typedocument,
                config_typevoucher.description as typevoucher")
            ->where('billing_notedocuments.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('billing_notedocuments.deleted_at', null);

        if($parameters != null) {
            if (isset($parameters['sunat_envio'])) {
                // check sunat envio
                if ($parameters['sunat_envio'] == config('app.sunat_pendiente')) {
                    $query = $query->where('billing_notedocuments.billing_external_id', null);
                } else if ($parameters['sunat_envio'] == config('app.sunat_enviado')) {
                    $query = $query->where('billing_notedocuments.billing_external_id', '!=', null);
                }
            }

            // check serie voucher
            if (isset($parameters['serie'])) {
                if($this->utilHelper->checkIsNullValue($parameters['serie'])!= null){
                    $query = $query->where('billing_notedocuments.serie', $parameters['serie']);
                }
            }


            if (isset($parameters['voucher'])) {
                if($this->utilHelper->checkCeroToNull($parameters['voucher'])!= null){
                    $query = $query->where('billing_notedocuments.voucher_id', $parameters['voucher']);
                }
            }else{
                $query = $query->whereBetween('billing_notedocuments.voucher_id', [config('app.voucher_creditnote_id'), config('app.voucher_debitnote_id')]);
            }


            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);
                        $query = $query
                            ->where('billing_notedocuments.nro_voucher', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                    }
                }
            }

            if (isset($parameters['start_range'])) {
                $query = $query->whereRaw("DATE(billing_notedocuments.date_document) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."'");
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('billing_notedocuments.date_document', 'DESC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('billing_notedocuments.date_document', 'DESC')->get()->toArray();
        }


        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], $attributes['serie'], $branchoffice_id);

        $item = new NoteDocument();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->movement_id = $attributes['movement_id'];
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->billingcode_id = $attributes['billingcode_id'];
        $item->client_id = $attributes['client_id'];
        $item->date_document = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->text_amount = $attributes['text_amount']; // convert txt;
        $item->serie = $attributes['serie'];
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->discount = $attributes['discount'];
        $item->total = $attributes['total'];
        $item->motive = $attributes['motive'];
        $item->exchange_currency = $attributes['exchange_currency'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
