<?php


namespace App\Models\Tenant\Billing\NoteDocumentDetail;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class NoteDocumentDetailRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new NoteDocumentDetail();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new NoteDocumentDetail();
        $item->notedocument_id = $attributes['notedocument_id'];
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unitmeasure_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->price_general = $attributes['price_general'];

        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo is_igv (se coloco para empresa nativa)

        if (isset($attributes['is_igv'])){
            $check_column = \Schema::connection("tenant")->hasColumn('sale_detailsales','is_igv');
            if($check_column)
                $item->is_igv = $attributes['is_igv'];
        }

        $item->save();
        return $item;

    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByNote($note_id)
    {
        $query = $this->obj->where('notedocument_id', $note_id)->get();
        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
