<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 27/07/2020
 * Time: 11:18 AM
 */

namespace App\Models\Tenant\Branch\BranchBoxes;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\Session;

class BranchBoxesRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new BranchBoxes();
        $this->utilHelper = new UtilHelper();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function checkBranchBoxSelected()
    {
        $check = false;
        // line branchoffice_id
        $branchoffice_id = Session::get('branchoffice_id');

        if (Session::has('branchbox_id'.$branchoffice_id)) {
            $check = true;
        }

        return $check;
    }

    public function selectBranchBox($box_id)
    {
        $branchoffice_id = Session::get('branchoffice_id');
        $val = Session::put('branchbox_id'.$branchoffice_id, $box_id);
        return $val;
    }

    public function getBranchBox($module_opening = false)
    {
        $id = null;
        $branchoffice_id = Session::get('branchoffice_id');

        if(!$module_opening) {
            if (!Session::has('branchbox_id'.$branchoffice_id)) {
                throw new \ErrorException('Por favor seleccione y aperture una caja para poder realizar movimientos de dinero.');
            }
        }

        $id = Session::get('branchbox_id'.$branchoffice_id);

//        if (Session::has('branchbox_id')) {
//            $id = Session::get('branchbox_id');
//        }

        return $id;
    }


    public function boxesByBranchOffice()
    {
        $branchoofice_id = $this->utilHelper->getBranchOffice();
        $query = $this->obj
            ->where('branchoffice_id', $branchoofice_id)
            ->where('deleted_at', null)
            ->get();

        return $query;
    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
       return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
