<?php

namespace App\Models\Tenant\Branch\BranchConfig;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class BranchConfig extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'branch_config';

    protected $appends = ["is_default_client", "typevoucher_default"];

    public function getisDefaultClientAttribute()
    {
        $is_default = false;
        $check_column = \Schema::connection("tenant")->hasColumn('branch_config','is_default_client');

        if($check_column == true){
            $is_default = $this->attributes['is_default_client'];
        }

        return $is_default;
    }

    public function gettypevoucherDefaultAttribute()
    {
        $is_default = 2;
        $check_column = \Schema::connection("tenant")->hasColumn('branch_config','typevoucher_default');

        if($check_column == true){
            $is_default = $this->attributes['typevoucher_default'];
        }

        return $is_default;
    }

}
