<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 05/08/2020
 * Time: 01:51 PM
 */

namespace App\Models\Tenant\Branch\BranchConfig;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\Session;

class BranchConfigRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new BranchConfig();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {

    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->print_boleta = $attributes['print_boleta'];
        $item->print_factura = $attributes['print_factura'];

        if (isset($attributes['is_default_client'])){
            $check_column = \Schema::connection("tenant")->hasColumn('branch_config','is_default_client');
            if($check_column)
                $item->is_default_client = $attributes['is_default_client'];
        }

        if (isset($attributes['typevoucher_default'])){
            $check_column = \Schema::connection("tenant")->hasColumn('branch_config','typevoucher_default');
            if($check_column)
                $item->typevoucher_default = $attributes['typevoucher_default'];
        }

        $item->save();

        return $item;
    }

    public function updatedConfigBarcode($is_barcode)
    {
        $val = $this->utilHelper->strToBooleanValue($is_barcode);
        Session::put('is_barcode', $val);
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByBranchoffice(){
        $branchoofice_id = $this->utilHelper->getBranchOffice();
        $query = $this->obj
            ->where('branchoffice_id', $branchoofice_id)
            ->where('deleted_at', null)
            ->first();
        return $query;
    }

    public function configBarcodeByBranchoffice()
    {
        if (!Session::has('is_barcode')) {
            Session::put('is_barcode', false);
        }

        $is_barcode = Session::get('is_barcode');
        return $is_barcode;
    }


    public function changeTheme($id,$theme)
    {
        $item = $this->obj->find($id);
        $item->theme = $theme;
        $item->save();
        return $item;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
