<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 05/08/2020
 * Time: 11:52 AM
 */

namespace App\Models\Tenant\Branch\BranchOffice;


use App\Models\Contract\BaseRepositoryInterface;

class BranchOfficeRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new BranchOffice();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allByUser()
    {
        if (auth()->user()->is_superadmin) {
            $query = $this->obj->all();
        } else {
            $query = $this->obj
                ->join('company_assignedbranchs', 'company_assignedbranchs.branchoffice_id', '=', 'branch_offices.id')
                ->selectRaw("branch_offices.*")
                ->where("company_assignedbranchs.employee_id", auth()->user()->employee_id)
                ->get();
        }
        return $query;
    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}