<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 28/06/2020
 * Time: 11:02 AM
 */

namespace App\Models\Tenant\Catalog\Brand;


use App\Helper\HelperChecker;
use App\Models\Contract\BaseRepositoryInterface;

class BrandRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new Brand();
        $this->helperChecker = new HelperChecker();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listBrands($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->selectRaw(
                "catalog_brands.description AS description,
                (SELECT count(*) FROM catalog_products WHERE catalog_products.brand_id = catalog_brands.id) as quantity_products")
            ->where('catalog_brands.deleted_at', null)
            ->orderBy("quantity_products", "DESC");

        if($parameters != null){
            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_brands.description', 'like', '%' . $text_search . '%');
                        });
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_brands.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_brands.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $this->helperChecker->checkSeemDescriptionModel($this->model(), 'description', $attributes['description'], 'Marca');

        $item = new Brand();
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $this->helperChecker->checkUpdateSeemDescriptionModel($id, $this->model(), 'description', $attributes['description'], 'Marca');

        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}