<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 25/06/2020
 * Time: 04:40 PM
 */

namespace App\Models\Tenant\Catalog\Category;


use App\Helper\HelperChecker;
use App\Models\Contract\BaseRepositoryInterface;

class CategoryRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new Category();
        $this->helperChecker = new HelperChecker();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listCategories($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->selectRaw(
                "description, (SELECT COUNT(*) FROM catalog_products
                    INNER JOIN catalog_lines ON catalog_products.line_id = catalog_lines.id
                    WHERE catalog_lines.category_id = catalog_categories.id
                ) AS quantity_products")
            ->where('catalog_categories.deleted_at', null)
            ->orderBy("quantity_products","DESC");

        if($parameters != null){
            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_categories.description', 'like', '%' . $text_search . '%');
                        });
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_categories.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_categories.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $this->helperChecker->checkSeemDescriptionModel($this->model(), 'description', $attributes['description'], 'Categoría');

        $item = new Category();
        $item->description = $attributes['description'];
        $item->description_content = $attributes['description_content'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $this->helperChecker->checkUpdateSeemDescriptionModel($id, $this->model(), 'description', $attributes['description'], 'Categoría');

        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->description_content = $attributes['description_content'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}