<?php

namespace App\Models\Tenant\Catalog\Line;

use App\Core\ModelsCore;
use App\Models\Tenant\Catalog\Category\CategoryRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Line extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'catalog_lines';

    protected $appends = ["category"];

    public function getcategoryAttribute()
    {
        if (isset($this->attributes['category_id'])) {
            $description = null;
            if($this->attributes['category_id']){
                $type = new CategoryRepository();
                $data = $type->find($this->attributes['category_id']);
                $description = $data['description'];
            }
            return $description;
        }
    }
}
