<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 27/06/2020
 * Time: 01:14 AM
 */

namespace App\Models\Tenant\Catalog\Line;


use App\Helper\HelperChecker;
use App\Models\Contract\BaseRepositoryInterface;

class LineRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new Line();
        $this->helperChecker = new HelperChecker();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listLines($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->selectRaw(
                "catalog_lines.description AS description,
                 catalog_categories.description AS category_description,
                 (SELECT count(*) FROM catalog_products WHERE catalog_products.line_id = catalog_lines.id) as quantity_products")
            ->join('catalog_categories', 'catalog_categories.id', '=', 'catalog_lines.category_id')
            ->where('catalog_lines.deleted_at', null)
            ->orderBy("quantity_products", "DESC");

        if($parameters != null){
            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_lines.description', 'like', '%' . $text_search . '%');
                        });
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_lines.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_lines.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function saleSummaryLine($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->selectRaw(
                "catalog_lines.description,
                (SELECT SUM(sale_detailsales.price*sale_detailsales.quantity) FROM sale_detailsales
                    INNER JOIN catalog_products ON sale_detailsales.product_id = catalog_products.id
                    WHERE catalog_products.line_id = catalog_lines.id AND DATE(sale_detailsales.created_at) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."') AS total_sale")
            ->join('catalog_categories', 'catalog_categories.id', '=', 'catalog_lines.category_id')
            ->where('catalog_lines.deleted_at', null)
            ->orderBy("total_sale", "ASC");

        if($parameters != null){
            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_lines.description', 'like', '%' . $text_search . '%');
                        });
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_lines.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_lines.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $item = new Line();
        $item->category_id = $this->helperChecker->convertIdCeroToNull($attributes['category_id']);
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->category_id = $this->helperChecker->convertIdCeroToNull($attributes['category_id']);
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}
