<?php

namespace App\Models\Tenant\Catalog\Product;

use App\Core\ModelsCore;
use App\Helper\StorageHelper;
use App\Models\System\TypeProduct\TypeProduct;
use App\Models\System\TypeProduct\TypeProductRepository;
use App\Models\Tenant\Catalog\ProductBatch\ProductBatchRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductPrice\ProductPriceRepository;
use App\Models\Tenant\Catalog\ProductStock\ProductStockRepository;
use App\Models\Tenant\Catalog\ProductVariant\ProductVariantRepository;
use App\Models\Tenant\Purchase\PurchaseDetail\PurchaseDetailRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Product extends ModelsCore
{
    use UsesTenantConnection;

    protected $storageHelper;

    protected $table = 'catalog_products';

    protected $appends = ["urlImageBase", "typeProductName", "isShow", "isFavorite", "isControlStock", "isLimitStock","price_sale", "unitsmeasure", "productstock",
     "productbatch", "productstockinreport", "price_purchase"];


    public function __construct()
    {
        $this->storageHelper = new StorageHelper();
    }

    public function geturlImageBaseAttribute()
    {
        if (isset($this->attributes['url_image'])) {
            $url_image = $this->attributes['url_image'];
            if ($url_image != null or $url_image != '') {
                $url_image = $this->storageHelper->getUrlImgProduct($url_image);
            }
            return $url_image;
        }
    }

    public function gettypeProductNameAttribute()
    {
        if (isset($this->attributes['type_product'])) {
            $type_product = new TypeProductRepository();
            $description = $type_product->find($this->attributes['type_product']);
            return $description['description'];
        }
    }

    public function getisShowAttribute()
    {
        if (isset($this->attributes['is_show'])) {
            $val = $this->attributes['is_show'];
            $res = true;
            if($val == 0 or $val == false){
                $res = false;
            }
            return $res;
        }
    }

    public function getisFavoriteAttribute()
    {
        if (isset($this->attributes['is_favorite'])) {
            $val = $this->attributes['is_favorite'];
            $res = true;
            if($val == 0 or $val == false){
                $res = false;
            }
            return $res;
        }

    }

    public function getisControlStockAttribute()
    {
        if (isset($this->attributes['is_control_stock'])) {
            $val = $this->attributes['is_control_stock'];
            $res = true;
            if($val == 0 or $val == false){
                $res = false;
            }
            return $res;
        }
    }

    public function getisLimitStockAttribute()
    {
        if (isset($this->attributes['is_limit_stock'])) {
            $val = $this->attributes['is_limit_stock'];
            $res = true;
            if($val == 0 or $val == false){
                $res = false;
            }
            return $res;
        }
    }

    public function getproductstockAttribute(){
        if (isset($this->attributes['is_control_stock'])) {
            $val = $this->attributes['is_control_stock'];
            $data = null;
            if($val){
                $rProductStock = new ProductStockRepository();
                $data = $rProductStock->findByProduct($this->attributes['id']);
            }

            return $data;
        }
    }

    public function getproductstockinreportAttribute(){
        if (isset($this->attributes['is_control_stock'])) {
            $val = $this->attributes['is_control_stock'];
            $data = null;
            if($val){
                $rProductStock = new ProductStockRepository();
                $data = $rProductStock->findByProductInReport($this->attributes['id']);
            }

            return $data;
        }
    }


    public function getpriceSaleAttribute()
    {
        if (isset($this->attributes['typeprice_id'])) {

            $type_price = $this->attributes['typeprice_id'];
            $price_sale = null;

            if($type_price == config('app.catalog_price_general')){
                $rProductPrice = new ProductPriceRepository();
                $data = $rProductPrice->findByProductId($this->attributes['id']);
                $price_sale = $data['price_sale'];
            }

            if($type_price == config('app.catalog_price_unit')){
                $rProductEquivalence = new ProductEquivalenceRepository();
                $data = $rProductEquivalence->findPrincipalMeasureByProduct($this->attributes['id']);
                $price_sale = $data['price_sale'];
            }

            if($type_price == config('app.catalog_price_variant')){
                $rProductVariant = new ProductVariantRepository();
                $data = $rProductVariant->findByProductId($this->attributes['id']);
                $data = $data[0];
                $price_sale = $data['price'];
            }

            return $price_sale;
        }
    }

    public function getpricePurchaseAttribute()
    {
        if (isset($this->attributes['is_control_stock'])) {
            $val = $this->attributes['is_control_stock'];
            $res =  0;
            if ($val) {
                $rPurchaseDetail = new PurchaseDetailRepository();
                $result = $rPurchaseDetail->averagePricePurchaseProduct($this->attributes['id']);
                if($result->average_price == null){
                    $res = 0;
                }
                else{
                    $res = number_format($result->average_price, 2);
                }
            }
            return $res;
        }
    }

    public function getproductbatchAttribute(){
        if (isset($this->attributes['is_control_expiration'])) {
            $response = null;
            $rProductBatch = new ProductBatchRepository();
            $productbatch = $rProductBatch->model()
                ->where('catalog_productbatch.deleted_at', null)
                ->where('catalog_productbatch.quantity', '>', 0)
                ->where('catalog_productbatch.product_id', $this->attributes['id'])
                ->get();

            if(count($productbatch) > 0){
                $response = $productbatch;
            }

            return $response;
        }
    }


    public function getunitsmeasureAttribute()
    {
        if (isset($this->attributes['typeprice_id'])) {
            $unitsmeasure = [];
            if ($this->attributes['typeprice_id'] == config('app.catalog_price_general')) {
                $rProductPrice = new ProductPriceRepository();
                $query = $rProductPrice->model()
                    ->join('config_unitsofmeasure', 'catalog_productprices.unit_id', '=', 'config_unitsofmeasure.id')
                    ->select('config_unitsofmeasure.*')
                    ->where('catalog_productprices.deleted_at', null)
                    ->where('catalog_productprices.product_id', $this->attributes['id'])
                    ->get();

                $unitsmeasure = $query;
            }

            if ($this->attributes['typeprice_id'] == config('app.catalog_price_unit')) {
                $rProductEquivalence = new ProductEquivalenceRepository();
                $query = $rProductEquivalence->model()
                    ->join('config_unitsofmeasure', 'catalog_productequivalences.unit_id', '=', 'config_unitsofmeasure.id')
                    ->select('config_unitsofmeasure.*',
                        'catalog_productequivalences.equivalence as equivalence',
                        'catalog_productequivalences.price_sale as price_sale')
                    ->where('catalog_productequivalences.deleted_at', null)
                    ->where('catalog_productequivalences.product_id', $this->attributes['id'])
                    ->orderBy('config_unitsofmeasure.is_principal', 'DESC')
                    ->get();

                $unitsmeasure = $query;
            }

            if ($this->attributes['typeprice_id'] == config('app.catalog_price_variant')) {
                $rProductVariant = new ProductVariantRepository();
                $query = $rProductVariant->model()
                    ->join('catalog_typevariants', 'catalog_productvariants.typevariant_id', '=', 'catalog_typevariants.id')
                    ->select(
                        'catalog_typevariants.description',
                        'catalog_productvariants.price_sale as price',
                        'catalog_productvariants.typevariant_id as id',
                        'catalog_productvariants.product_id as product_id',
                        'catalog_productvariants.unit_id as unit_id',
                        'catalog_productvariants.is_active as is_active',
                        'catalog_productvariants.equivalence as equivalence',
                        'catalog_productvariants.id as detail_id'
                    )
                    ->where('catalog_productvariants.product_id', $this->attributes['id'])
                    ->where('catalog_productvariants.deleted_at', null)
                    ->orderBy('catalog_productvariants.is_active', 'DESC')
                    ->get();

                $unitsmeasure = $query;
            }

            return $unitsmeasure;
        }
    }
}
