<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 22/05/2020
 * Time: 03:06 PM
 */

namespace App\Models\Tenant\Catalog\Product;

use App\Helper\HelperChecker;
use App\Helper\StorageHelper;
use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class ProductRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $storageHelper;
    protected $utilHelper;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new Product();
        $this->storageHelper = new StorageHelper();
        $this->utilHelper = new UtilHelper();
        $this->helperChecker = new HelperChecker();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function getProductsControlStock(){
        $query = $this->obj->where('is_control_stock', true)->where('deleted_at',null)->get();
        return $query;
    }


    public function listBienes($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->select("catalog_products.*", "catalog_brands.description as brand", "catalog_lines.description as line")
            ->leftJoin('catalog_brands', 'catalog_products.brand_id', '=', 'catalog_brands.id')
            ->leftJoin('catalog_lines', 'catalog_products.line_id', '=', 'catalog_lines.id')
            ->where("catalog_products.deleted_at", null)
            ->where('catalog_products.type_product', config('app.typeproduct_bienes'));


        if($parameters != null){
            if (isset($parameters['brand'])) {
                if($this->utilHelper->checkCeroToNull($parameters['brand']) != null){
                    $query = $query->where('catalog_products.brand_id', $parameters['brand']);
                }
            }

            if (isset($parameters['line'])) {
                if($this->utilHelper->checkCeroToNull($parameters['line'])!= null){
                    $query = $query->where('catalog_products.line_id', $parameters['line']);
                }
            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);


//                        $query = $query
//                            ->where('catalog_products.description', 'LIKE', '%' . $text_search . '%')
//                            ->orwhere('catalog_products.code', 'LIKE', '%'. $text_search.'%');

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_products.description', 'like', '%' . $text_search . '%')
                                ->orWhere('catalog_products.code', 'like', '%' . $text_search . '%');
                        });
                    }
                }
            }
        }


//        dd(($query->toSql()));

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_products.id', 'DESC')->get();
        }
        else{
            $query = $query
                ->skip(($page - 1) * $limit)
                ->take($limit)
                ->orderBy('catalog_products.id', 'DESC')->get()->toArray();
        }


        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function listServices($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->where('catalog_products.type_product', config('app.typeproduct_servicios'))
            ->where('catalog_products.deleted_at', null);

        if($parameters != null){

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_products.description', 'like', '%' . $text_search . '%')
                                ->orWhere('catalog_products.code', 'like', '%' . $text_search . '%');
                        });
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_products.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_products.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }


    public function listSaleFavorite($warehouse_id, $header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : 20;

        $query = $this->obj
            ->select("catalog_products.*")
            ->leftjoin('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
            ->where('catalog_products.is_favorite', true)
            ->where('catalog_productstock.warehouse_id', $warehouse_id)
            ->orwhere('catalog_products.is_control_stock', false)
            ->where('catalog_products.is_favorite', true);

        $all_data = $this->obj->where('catalog_products.is_favorite', true)->where('catalog_products.deleted_at', null)->get();

        $query = $query->where('catalog_products.deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();

        $response = array(
            'data' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => 20
        );

//        return $query;
        return $response;
    }


    public function listStockGeneral($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : 20;
        $warehouse = $header->has('warehouse') ? $header->get('warehouse') : 1;
        
        $query = $this->obj
            ->select("catalog_products.*", "catalog_brands.description as brand",
                "catalog_lines.description as line",
                "catalog_productstock.stock as stock",
                "config_unitsofmeasure.prefix as unitprefix")
            ->join('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
            ->leftJoin('catalog_brands', 'catalog_products.brand_id', '=', 'catalog_brands.id')
            ->leftJoin('catalog_lines', 'catalog_products.line_id', '=', 'catalog_lines.id')
            ->leftJoin('config_unitsofmeasure', 'catalog_productstock.unit_id', '=', 'config_unitsofmeasure.id')
            ->where('catalog_products.type_product', config('app.typeproduct_bienes'))
            // ->where('catalog_productstock.deleted_at', null)
            ->where('catalog_productstock.warehouse_id', $warehouse);

        // $all_data = $query->get();

//        $all_data = $this->obj
//            ->leftJoin('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
//            ->where('catalog_products.type_product', '1')
//            ->where('catalog_productstock.warehouse_id', $warehouse)
//            ->where('catalog_products.deleted_at', null)
//            ->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                // $query = $query
                //     ->where('catalog_products.description', 'LIKE', '%' . $text_search . '%')
                //     ->orwhere('catalog_products.code', 'LIKE', '%'. $text_search.'%');
                    $query = $query->where(function ($sql) use($text_search) {
                        $sql->where('catalog_products.description', 'LIKE', '%' . $text_search . '%')
                        ->orwhere('catalog_products.code', 'LIKE', '%'. $text_search.'%');
                    });
                // dd("here");
            }
        }

        $query = $query->where('catalog_productstock.warehouse_id', $warehouse);

        // dd($query->get());

//        dd($query->toSql());
        $all_data = $query->get();

        $query = $query
        ->where('catalog_products.deleted_at', null)->where('catalog_productstock.deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => 20
        );

//        return $query;
        return $response;
    }

    public function stockProduct($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : 20;
        $warehouse = $parameters->has('warehouse') ? $parameters->get('warehouse') : 1;

        $query = $this->obj
            ->leftJoin('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
            ->leftJoin('catalog_brands', 'catalog_products.brand_id', '=', 'catalog_brands.id')
            ->leftJoin('catalog_lines', 'catalog_products.line_id', '=', 'catalog_lines.id')
            ->select("catalog_products.*", "catalog_brands.description as brand", "catalog_lines.description as line")
            ->where('catalog_products.type_product', config('app.typeproduct_bienes'))
            ->where('catalog_productstock.warehouse_id', $warehouse)
            ->where('catalog_productstock.deleted_at', null)
            ->where('catalog_products.deleted_at', null);

        if($parameters != null){
            if (isset($parameters['stock_min'])) {
                if($this->utilHelper->checkIsNullValue($parameters['stock_min']) != null){
                    $query = $query->where('catalog_productstock.stock', '<=', $parameters['stock_min']);
                }
            }

            if (isset($parameters['brand'])) {
                if($this->utilHelper->checkCeroToNull($parameters['brand']) != null){
                    $query = $query->where('catalog_products.brand_id', $parameters['brand']);
                }
            }

            if (isset($parameters['line'])) {
                if($this->utilHelper->checkCeroToNull($parameters['line'])!= null){
                    $query = $query->where('catalog_products.line_id', $parameters['line']);
                }
            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_products.description', 'like', '%' . $text_search . '%')
                               ->orWhere('catalog_products.code', 'like', '%' . $text_search . '%');
                        });
                        // $query = $query
                        //     ->where('catalog_products.description', 'LIKE', '%' . $text_search . '%')
                        //     ->orwhere('catalog_products.code', 'LIKE', '%'. $text_search.'%');
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_products.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_products.id', 'ASC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => 20
        );

//        return $query;
        return $response;
    }


    public function create(array $attributes)
    {
        $code_product = $this->utilHelper->getCodeProduct($attributes['code'], $attributes['type_product']);
        $this->helperChecker->checkProductCode($attributes['code']);

        $item = new Product();
        $item->code = $code_product;
        $item->typeprice_id = $attributes['typeprice_id'];
        $item->type_product = $attributes['type_product'];
        $item->brand_id = $this->helperChecker->convertIdCeroToNull($attributes['brand_id']);
        $item->line_id = $this->helperChecker->convertIdCeroToNull($attributes['line_id']);
        $item->description = $attributes['description'];
        $item->comment = $attributes['comment'];
        $item->is_show = $this->utilHelper->strToBooleanValue($attributes['is_show']);
        $item->is_favorite = $this->utilHelper->strToBooleanValue($attributes['is_favorite']);
        $item->is_control_stock = $this->utilHelper->strToBooleanValue($attributes['is_control_stock']);
        $item->is_limit_stock = $this->utilHelper->strToBooleanValue($attributes['is_limit_stock']);
        $item->limit_stock = $attributes['limit_stock'];
        $item->is_control_expiration = $this->utilHelper->strToBooleanValue($attributes['is_control_expiration']);
        $item->is_limit_expiration = $this->utilHelper->strToBooleanValue($attributes['is_limit_expiration']);
        $item->limit_expiration = $attributes['limit_expiration'];

        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo is_grouped - tabla productos(produtos agrupados)
        if (isset($attributes['is_grouped'])){
            $check_column = \Schema::connection("tenant")->hasColumn('catalog_products','is_grouped');
            if($check_column){
                $item->is_grouped = $attributes['is_grouped'];
            }
        }

        $item->save();
        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function createService(array $attributes)
    {
        $code_product = $this->utilHelper->getCodeProduct($attributes['code'], $attributes['type_product']);
        $this->helperChecker->checkProductCode($attributes['code']);

        $item = new Product();
        $item->code = $code_product;
        $item->typeprice_id = $attributes['typeprice_id'];
        $item->type_product = $attributes['type_product'];
        $item->description = $attributes['description'];
        $item->is_show = $this->utilHelper->strToBooleanValue($attributes['is_show']);
        $item->is_favorite = $this->utilHelper->strToBooleanValue($attributes['is_favorite']);
        $item->save();
        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $this->helperChecker->checkProductCodeUpdate($attributes['code'], $id);
        $code_product = $this->utilHelper->getCodeProduct($attributes['code'], $attributes['type_product']);

        $item = $this->obj->find($id);
        $item->code = $code_product;
        $item->typeprice_id = $attributes['typeprice_id'];
        $item->type_product = $attributes['type_product'];
        $item->brand_id = $this->helperChecker->convertIdCeroToNull($attributes['brand_id']);
        $item->line_id = $this->helperChecker->convertIdCeroToNull($attributes['line_id']);
        $item->description = $attributes['description'];
        $item->comment = $attributes['comment'];
        $item->is_show = $this->utilHelper->strToBooleanValue($attributes['is_show']);
        $item->is_favorite = $this->utilHelper->strToBooleanValue($attributes['is_favorite']);
        $item->is_control_stock = $this->utilHelper->strToBooleanValue($attributes['is_control_stock']);
        $item->is_limit_stock = $this->utilHelper->strToBooleanValue($attributes['is_limit_stock']);
        $item->limit_stock = $attributes['limit_stock'];
        $item->is_control_expiration = $this->utilHelper->strToBooleanValue($attributes['is_control_expiration']);
        $item->is_limit_expiration = $this->utilHelper->strToBooleanValue($attributes['is_limit_expiration']);
        $item->limit_expiration = $attributes['limit_expiration'];
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function setIsControlStock($id)
    {
        $item = $this->obj->find($id);
        $item->is_control_stock = true;
        $item->save();

        return $item;
    }

    public function setIsControlExpiration($id)
    {
        $item = $this->obj->find($id);
        $item->is_control_expiration = true;
        $item->save();

        return $item;
    }

    public function saveUrlImage($item, $attributes)
    {
        $image = $attributes['url_image'];
        $attributes['product_id'] = $item->id;
        if ($image != null) {
            $file_url = $this->storageHelper->saveUrlImgProduct($attributes);
            $item->url_image = $file_url;
            $item->save();
        }
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function findByJoinedProformaDetail($proforma_id){
        return $this->obj
            ->join('sale_detailproformas', 'catalog_products.id', '=', 'sale_detailproformas.product_id')
            ->select('sale_detailproformas.*',
                'catalog_products.typeprice_id as typeprice_id',
                'catalog_products.description as description',
                'sale_detailproformas.id as detail_id',
                'sale_detailproformas.product_id as id',
                DB::raw('(sale_detailproformas.quantity * sale_detailproformas.price) as subtotal'),
                DB::raw('(sale_detailproformas.quantity * sale_detailproformas.price + sale_detailproformas.igv) as total'))
            ->where('sale_detailproformas.deleted_at', null)
            ->where('sale_detailproformas.proforma_id', $proforma_id)
            ->get();
    }

    public function findByJoinedOrderDetail($order_id){
        return $this->obj
            ->join('sale_detailorders', 'catalog_products.id', '=', 'sale_detailorders.product_id')
            ->select('sale_detailorders.*',
                'catalog_products.typeprice_id as typeprice_id',
                'catalog_products.description as description',
                'catalog_products.is_control_stock as is_control_stock',
                'catalog_products.is_favorite as is_favorite',
                'catalog_products.is_control_expiration as is_control_expiration',
                'catalog_products.is_limit_expiration as is_limit_expiration',
                'catalog_products.is_limit_stock as is_limit_stock',
                'catalog_products.limit_expiration as limit_expiration',
                'catalog_products.limit_stock as limit_stock',
                'catalog_products.is_show as is_show',
                'sale_detailorders.id as detail_id',
                'sale_detailorders.product_id as id',
                DB::raw('(sale_detailorders.quantity * sale_detailorders.price) as subtotal'),
                DB::raw('(sale_detailorders.quantity * sale_detailorders.price + sale_detailorders.igv) as total'))
            ->where('sale_detailorders.deleted_at', null)
            ->where('sale_detailorders.order_id', $order_id)
            ->get();
    }

    public function findByJoinedOrderPurchaseDetail($order_id){
        return $this->obj
            ->join('purchase_detailorders', 'catalog_products.id', '=', 'purchase_detailorders.product_id')
            ->select('purchase_detailorders.*',
                'catalog_products.typeprice_id as typeprice_id',
                'catalog_products.description as description',
                'catalog_products.is_control_stock as is_control_stock',
                'catalog_products.is_favorite as is_favorite',
                'catalog_products.is_control_expiration as is_control_expiration',
                'catalog_products.is_limit_expiration as is_limit_expiration',
                'catalog_products.is_limit_stock as is_limit_stock',
                'catalog_products.limit_expiration as limit_expiration',
                'catalog_products.limit_stock as limit_stock',
                'catalog_products.is_show as is_show',
                'purchase_detailorders.id as detail_id',
                'purchase_detailorders.product_id as id',
                DB::raw('(purchase_detailorders.quantity * purchase_detailorders.price) as subtotal'),
                DB::raw('(purchase_detailorders.quantity * purchase_detailorders.price + purchase_detailorders.igv) as total'))
            ->where('purchase_detailorders.deleted_at', null)
            ->where('purchase_detailorders.order_id', $order_id)
            ->get();
    }

    public function findByJoinedSaleDetail($sale_id){
        return $this->obj
            ->join('sale_detailsales', 'catalog_products.id', '=', 'sale_detailsales.product_id')
            ->select('sale_detailsales.*',
                'catalog_products.typeprice_id as typeprice_id',
                'catalog_products.description as description',
                'catalog_products.is_control_stock as is_control_stock',
                'catalog_products.is_favorite as is_favorite',
                'catalog_products.is_control_expiration as is_control_expiration',
                'catalog_products.is_limit_expiration as is_limit_expiration',
                'catalog_products.is_limit_stock as is_limit_stock',
                'catalog_products.limit_expiration as limit_expiration',
                'catalog_products.limit_stock as limit_stock',
                'catalog_products.is_show as is_show',
                'sale_detailsales.id as detail_id',
                'sale_detailsales.product_id as id',
                DB::raw('(sale_detailsales.quantity * sale_detailsales.price) as subtotal'),
                DB::raw('(sale_detailsales.quantity * sale_detailsales.price + sale_detailsales.igv) as total'))
            ->where('sale_detailsales.deleted_at', null)
            ->where('sale_detailsales.sale_id', $sale_id)
            ->get();
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }

    public function saleSearch($text, $warehouse_id)
    {
        $text_search = strtoupper($text);

        // dd($text, $warehouse_id);

        $first_part = $this->obj
            ->select("catalog_products.*")
            ->join('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
            ->where('catalog_products.deleted_at', null)
            ->where('catalog_productstock.warehouse_id', $warehouse_id);
            $first_part = $first_part->where(function ($sql) use($text_search) {
                $sql->where('catalog_products.description', 'like', '%' . $text_search . '%')
                   ->orWhere('catalog_products.code', 'like', '%' . $text_search . '%');
            });

        $second_part = $this->obj
            ->select("catalog_products.*")
            ->where('catalog_products.deleted_at', null)
            ->where('catalog_products.is_control_stock', false);
            
            $second_part = $second_part->where(function ($sql) use($text_search) {
                $sql->where('catalog_products.description', 'like', '%' . $text_search . '%')
                   ->orWhere('catalog_products.code', 'like', '%' . $text_search . '%');
            });

            $second_part = $second_part
                ->orderBy("catalog_products.is_control_stock","ASC")
                ->union($first_part)
                ->get();    


        // $second_part = $second_part->where('catalog_products.deleted_at', null)->get(); 

//        $query = $this->obj
//            ->select("catalog_products.*")
//            ->leftJoin('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
//            ->where('catalog_productstock.warehouse_id', $warehouse_id)
//            ->where('catalog_products.is_control_stock', false)
// //            ->where('catalog_products.deleted_at', null)
//            ->where('catalog_products.description', 'LIKE', '%' . $text_search . '%')
//            ->get();

//        return $query;

        return  $second_part;
    }

//    public function searchTypeBienes($text, $control_stock)
    public function searchTypeBienes($parameters)
    {
//        $text_search = strtoupper($text);
        $data = $this->obj
            ->where('deleted_at', null)
            ->where('type_product', config('app.typeproduct_bienes'));


        if (isset($parameters['search'])) {
            $text_search = strtoupper($parameters['search']);
            // $data = $data

            $data = $data->where(function ($sql) use($text_search) {
                $sql->where('description', 'like', '%' . $text_search . '%')
                   ->orWhere('code', 'like', '%' . $text_search . '%');
            });

            // ->where('description', 'LIKE', '%' . $text_search . '%')
            // ->orWhere('code', 'LIKE', '%' . $text_search . '%');
        }

        if (isset($parameters['control_stock'])) {
            $control_stock = $parameters['control_stock'];
            if ($this->utilHelper->strToBooleanValue($control_stock) == true) {
                $data = $data->where('is_control_stock', true);
            }
        }

        return $data->get()->toArray();
    }

    public function searchBienesAndServicios($text)
    {
        $text_search = strtoupper($text);
        $data = $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();

        return $data;
    }


    public function rowExportStockGeneral($header)
    {

        $warehouse = $header['warehouse'];

        $query = $this->obj
            ->select("catalog_products.*", "catalog_brands.description as brand", "catalog_lines.description as line")
            ->leftJoin('catalog_productstock', 'catalog_products.id', '=', 'catalog_productstock.product_id')
            ->leftJoin('catalog_brands', 'catalog_products.brand_id', '=', 'catalog_brands.id')
            ->leftJoin('catalog_lines', 'catalog_products.line_id', '=', 'catalog_lines.id')
            ->where('catalog_products.type_product', config('app.typeproduct_bienes'))
            ->where('catalog_productstock.warehouse_id', $warehouse)
            ->orderBy('catalog_products.id', 'DESC')
            ->get();

        return $query;
    }


    public function searchByCategory($category_id)
    {
        $query = $this->obj
            ->select("catalog_products.*")
            ->join('catalog_lines', 'catalog_products.line_id', '=', 'catalog_lines.id')
            ->where('catalog_lines.category_id', $category_id)
            ->get();
        return $query;

    }


    public function saleUtilityProduct($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->selectRaw(
                "*,
                catalog_products.description,
                ROUND((SELECT SUM(CASE WHEN sale_detailsales.equivalence_val ISNULL THEN sale_detailsales.quantity ELSE sale_detailsales.quantity*sale_detailsales.equivalence_val END
                ) FROM sale_detailsales
                WHERE sale_detailsales.product_id = catalog_products.id AND DATE(sale_detailsales.created_at) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."'),2) as quantity_sale,
                (SELECT
                    ROUND(
                    (SUM(sale_detailsales.price*sale_detailsales.quantity))/
                    (SUM(sale_detailsales.quantity * ( CASE WHEN sale_detailsales.equivalence_val ISNULL THEN 1 ELSE sale_detailsales.equivalence_val END)))
                    ,3)FROM sale_detailsales
                        WHERE sale_detailsales.product_id = catalog_products.id AND DATE(sale_detailsales.created_at) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."') AS average_price_sale,

                (SELECT
                    ROUND(
                    (SUM(purchase_detailpurchases.price*purchase_detailpurchases.quantity))/
                    (SUM(purchase_detailpurchases.quantity * ( CASE WHEN purchase_detailpurchases.equivalence ISNULL THEN 1 ELSE purchase_detailpurchases.equivalence END)))
                    ,3)FROM purchase_detailpurchases
			        WHERE purchase_detailpurchases.product_id = catalog_products.id AND DATE(purchase_detailpurchases.created_at) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."') AS average_price_purchase")
            ->where('catalog_products.deleted_at', null);

        if($parameters != null){

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('catalog_products.description', 'like', '%' . $text_search . '%')
                                ->orWhere('catalog_products.code', 'like', '%' . $text_search . '%');
                        });
                    }

                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('catalog_products.id', 'ASC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('catalog_products.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }
}
