<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 05/08/2020
 * Time: 10:03 PM
 */

namespace App\Models\Tenant\Catalog\ProductBatch;


use App\Models\Contract\BaseRepositoryInterface;

class ProductBatchRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new ProductBatch();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        // sotore item
    }

    public function substractBatchProduct($id, $data)
    {
        $item = $this->obj->find($id);
        $last_stock = $item->quantity;
        $update_quantity = $last_stock - $data['quantity'];
        $item->quantity = $update_quantity;
        $item->save();
        return $item;
    }

    public function increaseBatchProduct($id, $data)
    {
        $item = $this->obj->find($id);
        $last_stock = $item->quantity;
        $update_quantity = $last_stock + $data['quantity'];
        $item->quantity = $update_quantity;
        $item->save();
        return $item;
    }

    public function checkBatchProduct($data)
    {
        $item = $this->obj
            ->where('warehouse_id', $data['warehouse_id'])
            ->where('product_id', $data['product_id'])
            ->where('date_expiration', $data['date_expiration'])
            ->first();

        if ($item != null) {
            $last_quantity = $item->quantity;
            $update_quantity = $last_quantity + $data['quantity'];
            $item->quantity = $update_quantity;
            $item->save();
            return $item;
        } else {
            $batchs_product = $this->obj->where('warehouse_id', $data['warehouse_id'])->where('product_id', $data['product_id'])->get();
            $number_batch = count($batchs_product) + 1;
            $item = $this->createBatchProduct($data, $number_batch);
            return $item;
        }
    }


    public function substractBatch($data)
    {
        $item = $this->obj->find($data['batch_id']);
        $last_quantity = $item->quantity;
        if ($data['quantity'] > $last_quantity) {
            $item->quantity = 0;
            $item->save();

            $diference = $data['quantity'] - $last_quantity;

            $replace = $this->obj
                ->where('warehouse_id', $data['warehouse_id'])
                ->where('product_id', $data['product_id'])
                ->where('id', '<>', $data['batch_id'])
                ->first();

            $replace_quantity = $replace->quantity;
            $substract = $replace_quantity - $diference;
            $replace->quantity = $substract;
            $replace->save();
        }
        else {
            $update_quantity = $last_quantity - $data['quantity'];
            $item->quantity = $update_quantity;
            $item->save();
        }

        return $item;
    }


    public function createBatchProduct($attributes, $number_batch)
    {
        $item = new ProductBatch();
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->date_expiration = $attributes['date_expiration'];
        $item->quantity = $attributes['quantity'];
        $item->number_batch = $number_batch;
        $item->save();
        return $item;
    }

    public function findByProductAndWarehouse($product_id, $warehouse_id)
    {
        $query = $this->obj
            ->where('warehouse_id', $warehouse_id)
            ->where('product_id', $product_id)
            ->where('quantity','>', 0)
            ->orderBy('date_expiration', 'DESC')
            ->get();
        return $query;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }


    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}