<?php

namespace App\Models\Tenant\Catalog\ProductEquivalence;


use App\Models\Contract\BaseRepositoryInterface;

class ProductEquivalenceRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new ProductEquivalence();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ProductEquivalence();
        $item->product_id = $attributes['product_id'];
        $item->unit_id = $attributes['unit_id'];
        $item->equivalence = $attributes['equivalence'];
        $item->price_sale = $attributes['price'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->equivalence = $attributes['equivalence'];
        $item->price_sale = $attributes['price'];
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findByProductId($product_id)
    {
        return $this->obj
            ->join('config_unitsofmeasure', 'catalog_productequivalences.unit_id', '=', 'config_unitsofmeasure.id')
            ->select('config_unitsofmeasure.description',
                    'config_unitsofmeasure.is_principal',
                    'config_unitsofmeasure.prefix',
                    'catalog_productequivalences.equivalence',
                    'catalog_productequivalences.price_sale as price',
                    'catalog_productequivalences.unit_id as id',
                    'catalog_productequivalences.product_id as product_id',
                    'catalog_productequivalences.id as detail_id')
            ->where('product_id', $product_id)
            ->where('catalog_productequivalences.deleted_at', null)
            ->orderBy('config_unitsofmeasure.is_principal', 'DESC')
            ->get();
    }

    public function findByProductAndUnit($product_id, $unit_id)
    {
        return $this->obj
            ->where('product_id', $product_id)
            ->where('unit_id', $unit_id)
            ->where('deleted_at', null)
            ->first();
    }

    public function findPrincipalMeasureByProduct($product_id)
    {
        return $this->obj
            ->join('config_unitsofmeasure', 'catalog_productequivalences.unit_id', '=', 'config_unitsofmeasure.id')
            ->select('catalog_productequivalences.*')
            ->where('config_unitsofmeasure.is_principal', true)
            ->where('catalog_productequivalences.product_id', $product_id)
            ->where('catalog_productequivalences.deleted_at', null)
            ->first();
    }


    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function deletedByProductAndUnit($product_id, $unit_id)
    {
        $item = $this->obj
            ->where('product_id',$product_id)
            ->where('unit_id', $unit_id)
            ->where('catalog_productequivalences.deleted_at', null)
            ->first();
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}