<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 24/12/2020
 * Time: 08:15 PM
 */

namespace App\Models\Tenant\Catalog\ProductGrouped;


use App\Models\Contract\BaseRepositoryInterface;

class ProductGroupedRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new ProductGrouped();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ProductGrouped();
        $item->product_id = $attributes['product_id'];
        $item->productextends_id = $attributes['id'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function findByProductId($product_id)
    {
        $query = $this->obj
            ->join('catalog_products', 'catalog_productgroupeds.productextends_id', '=', 'catalog_products.id')
            ->select(
                "catalog_products.*",
                "catalog_productgroupeds.productextends_id as id",
                "catalog_productgroupeds.id as detail_id")
            ->where('catalog_productgroupeds.product_id', $product_id)
            ->where('catalog_productgroupeds.deleted_at', null)
            ->get();

        return $query;
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByProductAndExtend($product_id, $extend_id)
    {
        return $this->obj
            ->where('product_id', $product_id)
            ->where('productextends_id', $extend_id)
            ->first();
    }

    public function deletedByProductAndExtend($product_id, $extends_id)
    {
        $item = $this->obj
            ->where('catalog_productgroupeds.product_id',$product_id)
            ->where('catalog_productgroupeds.productextends_id', $extends_id)
            ->where('catalog_productgroupeds.deleted_at', null)
            ->first();

        $item->delete();
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}