<?php

namespace App\Models\Tenant\Catalog\ProductPrice;


use App\Models\Contract\BaseRepositoryInterface;

class ProductPriceRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new ProductPrice();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ProductPrice();
        $item->product_id = $attributes['product_id'];
        $item->unit_id = $attributes['unit_id'];
        $item->price_purchase = $attributes['price_purchase'];
        $item->price_min = $attributes['price_min'];
        $item->price_sale = $attributes['price_sale'];
        $item->price_credit = $attributes['price_credit'];
        $item->price_wholesaler = $attributes['price_wholesaler'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->product_id = $attributes['product_id'];
        $item->unit_id = $attributes['unit_id'];
        $item->price_sale = $attributes['price_sale'];
        $item->price_purchase = $attributes['price_purchase'];
        $item->price_min = $attributes['price_min'];
        $item->price_credit = $attributes['price_credit'];
        $item->price_wholesaler = $attributes['price_wholesaler'];
        $item->save();
        return $item;

    }

    public function createForProductImport($product_id)
    {
        $item = new ProductPrice();
        $item->product_id = $product_id;
        $item->unit_id = 1;
        $item->price_min = 0;
        $item->price_sale = 0;
        $item->save();
        return $item;
    }

    public function find($id)
    {

    }

    public function findByProductId($product_id)
    {
        return $this->obj->where('product_id', $product_id)->first();
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
