<?php

namespace App\Models\Tenant\Catalog\ProductStock;

use App\Core\ModelsCore;
use App\Models\Tenant\Config\UnitMeasure\UnitMeasureRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class ProductStock extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'catalog_productstock';

    protected $appends = ["unitprefix"];

    public function getunitprefixAttribute()
    {
        if (isset($this->attributes['unit_id'])) {
            $rUnitMeasure = new UnitMeasureRepository();
            $data = $rUnitMeasure->find($this->attributes['unit_id']);

            return $data['prefix'];
        }
    }

}
