<?php

/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 30/06/2020
 * Time: 02:24 PM
 */

namespace App\Models\Tenant\Catalog\ProductStock;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use App\Models\Tenant\Warehouse\Warehouse\WarehouseRepository;

class ProductStockRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $rWarehouseRepository;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new ProductStock();
        $this->rWarehouseRepository = new WarehouseRepository();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ProductStock();
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unit_id = $attributes['unit_id'];
        $item->stock = $attributes['stock'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unit_id = $attributes['unit_id'];
        $item->stock = $attributes['stock'];
        $item->save();
        return $item;
    }

    public function updatedStockByWarehouse($product_id, $data)
    {
        $item = $this->obj->where('product_id', $product_id)->where('warehouse_id', $data['warehouse_id'])->where('catalog_productstock.deleted_at', null)->first();

        if ($item != null) {
            $last_stock = $item->stock;
            $update_quantity = $last_stock + $data['quantity'];
            $item->stock = $update_quantity;
            $item->save();
            return $item;
        } else {
            $this->create($data);
        }
    }

    public function substractStockByWarehouse($product_id, $data, $deleted_entry = false)
    {
        $item = $this->obj->where('product_id', $product_id)->where('warehouse_id', $data['warehouse_id'])->where('catalog_productstock.deleted_at', null)->first();

        if ($item != null) {
            $last_stock = $item->stock;

            if ($last_stock < $data['quantity']) {

                $message = 'La cantidad a retirar del producto ' . $data['description'] . ' es mayor que su stock actual ( ' . $item->stock . ' )';

                if ($deleted_entry)
                    $message = 'El stock actual del producto ' . $data['product'] . ' es ( ' . $item->stock . ' ), 
                                por lo cual no se puede retornar la cantidad (' . $data['quantity'] . ') ingresados para este registro de entrada.';

                throw new \ErrorException($message);
            }

            $update_quantity = $last_stock - $data['quantity'];
            $item->stock = $update_quantity;
            $item->save();
            return $item;
        } else {
            $this->create($data);
        }
    }


    public function substractStockByWarehouseFromSale($product_id, $data)
    {
        $item = $this->obj->where('product_id', $product_id)->where('warehouse_id', $data['warehouse_id'])->first();

        if ($item != null) {
            $last_stock = $item->stock;

            if ($last_stock < $data['quantity']) {

                $message = 'La cantidad a despachar del producto ' . $data['description'] . ' es mayor que su stock actual ( ' . $item->stock . ' )';

                throw new \ErrorException($message);
            }
            $update_quantity = $last_stock - $data['quantity'];
            $item->stock = $update_quantity;
            $item->save();
            return $item;
        } else {
            $message = 'El producto no tiene habilitado el control de stock';
            throw new \ErrorException($message);
        }
    }


    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByProductAndWarehouse($product_id)
    {
        $warehouse_principal = $this->rWarehouseRepository->warehousePrincipal();
        $item = $this->obj->where('product_id', $product_id)->where('warehouse_id', $warehouse_principal[0]->id)->first();
        return $item;
    }

    public function findByProduct($product_id)
    {
        $item = $this->obj
            ->join('config_unitsofmeasure', 'catalog_productstock.unit_id', '=', 'config_unitsofmeasure.id')
            ->join('warehouse_warehouses', 'catalog_productstock.warehouse_id', '=', 'warehouse_warehouses.id')
            // ->select('catalog_productstock.*', 'config_unitsofmeasure.plural as unidad_plural')
            ->selectRaw("catalog_productstock.*, config_unitsofmeasure.plural as unidad_plural, warehouse_warehouses.description warehouse_description")
            ->where('product_id', $product_id)            
            ->where('catalog_productstock.deleted_at', null)
            ->where('warehouse_warehouses.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->get();
        return $item;
    }

    public function findByProductInReport($product_id)
    {
        $item = $this->obj
            ->join('config_unitsofmeasure', 'catalog_productstock.unit_id', '=', 'config_unitsofmeasure.id')
            ->join('warehouse_warehouses', 'catalog_productstock.warehouse_id', '=', 'warehouse_warehouses.id')
            // ->select('catalog_productstock.*', 'config_unitsofmeasure.plural as unidad_plural')
            ->selectRaw("catalog_productstock.*, config_unitsofmeasure.plural as unidad_plural, warehouse_warehouses.description warehouse_description")
            ->where('product_id', $product_id)            
            ->where('catalog_productstock.deleted_at', null)
            ->get();
        return $item;
    }

    public function listStockAvailablesFromProduct()
    {
        $query = $this->obj
            ->join('catalog_products', 'catalog_productstock.product_id', '=', 'catalog_products.id')
            ->select('catalog_productstock.*')
            ->where('catalog_products.deleted_at', null)
            ->where('catalog_productstock.stock', '>', 0)
            ->orderBy('catalog_products.id', 'ASC')
            ->get();

        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
