<?php

namespace App\Models\Tenant\Catalog\ProductVariant;

use App\Core\ModelsCore;
use App\Models\Tenant\Catalog\TypeVariant\TypeVariantRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class ProductVariant extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'catalog_productvariants';

    protected $appends = ["type"];


    public function gettypeAttribute()
    {
        if (isset($this->attributes['typevariant_id'])) {
            $model = new TypeVariantRepository();
            $data = $model->find($this->attributes['typevariant_id']);
            return $data['description'];
        }
    }





}
