<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 24/12/2020
 * Time: 05:16 PM
 */

namespace App\Models\Tenant\Catalog\ProductVariant;


use App\Models\Contract\BaseRepositoryInterface;

class ProductVariantRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new ProductVariant();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ProductVariant();
        $item->product_id = $attributes['product_id'];
        $item->typevariant_id = $attributes['typevariant_id'];
        $item->unit_id = $attributes['unit_id'];
        $item->price_sale = $attributes['price'];
        $item->equivalence = $attributes['equivalence'];
        $item->is_active = $attributes['is_active'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->unit_id = $attributes['unit_id'];
        $item->price_sale = $attributes['price'];
        $item->equivalence = $attributes['equivalence'];
        $item->is_active = $attributes['is_active'];
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function findByProductId($product_id)
    {
        $query = $this->obj
            ->join('catalog_typevariants', 'catalog_productvariants.typevariant_id', '=', 'catalog_typevariants.id')
            ->select(
                'catalog_typevariants.description',
                'catalog_productvariants.price_sale as price',
                'catalog_productvariants.typevariant_id as id',
                'catalog_productvariants.product_id as product_id',
                'catalog_productvariants.unit_id as unit_id',
                'catalog_productvariants.is_active as is_active',
                'catalog_productvariants.equivalence as equivalence',
                'catalog_productvariants.id as detail_id'
            )
            ->where('catalog_productvariants.product_id', $product_id)
            ->where('catalog_productvariants.deleted_at', null)
            ->orderBy('catalog_productvariants.is_active', 'DESC')
            ->get();

        return $query;
    }

    public function findByProductAndTypeVariant($product_id, $type_id)
    {
        return $this->obj
            ->where('product_id', $product_id)
            ->where('typevariant_id', $type_id)
//            ->where('deleted_at', null)
            ->first();
    }

    public function deletedByProductAndTypeVariant($product_id, $type_id)
    {
        $item = $this->obj
            ->where('product_id',$product_id)
            ->where('typevariant_id', $type_id)
            ->where('catalog_productvariants.deleted_at', null)
            ->first();

        $item->delete();
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}