<?php

namespace App\Models\Tenant\Catalog\TypeVariant;


use App\Models\Contract\BaseRepositoryInterface;

class TypeVariantRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new TypeVariant();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new TypeVariant();
        $item->variant_id = $attributes['variant_id'];
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findByVariantId($variant_id)
    {
        $data = $this->obj->where('variant_id', $variant_id)->where('deleted_at', null)->get();
        return $data;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}