<?php

namespace App\Models\Tenant\Catalog\Variant;

use App\Core\ModelsCore;
use App\Models\Tenant\Catalog\TypeVariant\TypeVariantRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Variant extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'catalog_variants';

    protected $appends = ["types"];

    protected $rTypeVariant;

    public function __construct()
    {
        $this->rTypeVariant = new TypeVariantRepository();
    }
    
    public function gettypesAttribute()
    {
        $types = [];
        if ($this->attributes['id']) {
            $types = $this->rTypeVariant->findByVariantId($this->attributes['id']);
        }
        return $types;
    }
}
