<?php

namespace App\Models\Tenant\Catalog\Variant;

use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class VariantRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new Variant();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function searchTypesByVariant($variant_id)
    {
        $query = DB::connection('tenant')
            ->select("SELECT * FROM catalog_typevariants WHERE catalog_typevariants.variant_id = ".$variant_id);

        return $query;
    }

    public function create(array $attributes)
    {
        $item = new Variant();
        $item->description = $attributes['description'];
        $item->comment = $attributes['comment'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->comment = $attributes['comment'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}