<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 27/08/2020
 * Time: 01:52 PM
 */

namespace App\Models\Tenant\Company\AssignedBranch;


use App\Models\Contract\BaseRepositoryInterface;

class AssignedBranchRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new AssignedBranch();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new AssignedBranch();
        $item->employee_id = $attributes['employee_id'];
        $item->branchoffice_id = $attributes['id'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function findByEmployee($employee_id)
    {
        $query = $this->obj
            ->join('branch_offices', 'company_assignedbranchs.branchoffice_id','=','branch_offices.id')
            ->select("branchoffice_id as id", "employee_id", "company_assignedbranchs.id as detail_id", "branch_offices.description as branchoffice")
            ->where('company_assignedbranchs.employee_id', $employee_id)
            ->where('company_assignedbranchs.deleted_at', null)
            ->get();
        return $query;
    }

    public function findByEmployeeAndBranchoffice($employee_id, $branchoffice_id)
    {
        $query = $this->obj
            ->where('employee_id', $employee_id)
            ->where('branchoffice_id', $branchoffice_id)
            ->first();
        return $query;
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}