<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 25/08/2020
 * Time: 11:51 AM
 */

namespace App\Models\Tenant\Company\CompanyJob;


use App\Helper\HelperChecker;
use App\Models\Contract\BaseRepositoryInterface;

class CompanyJobRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new CompanyJob();
        $this->helperChecker = new HelperChecker();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $this->helperChecker->checkSeemDescriptionModel($this->model(), 'description', $attributes['description'], 'Puesto');

        $item = new CompanyJob();
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $this->helperChecker->checkUpdateSeemDescriptionModel($id, $this->model(), 'description', $attributes['description'], 'Puesto');

        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}