<?php

namespace App\Models\Tenant\Company\Employee;

use App\Core\ModelsCore;
use App\Helper\StorageHelper;
use App\Models\Tenant\Company\AssignedBranch\AssignedBranchRepository;
use App\Models\Tenant\Company\CompanyJob\CompanyJobRepository;
use App\Models\Tenant\Config\TypeDocument\TypeDocumentRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Employee extends ModelsCore
{
    use UsesTenantConnection;

    protected $storageHelper;

    protected $table = 'company_employees';

    protected $appends = ["urlImageBase", "typeDocument", "jobassigned", "assignedbranchs"];

    public function __construct()
    {
        $this->storageHelper = new StorageHelper();
    }

    public function geturlImageBaseAttribute()
    {
        if (isset($this->attributes['url_image'])) {
            $url_image = $this->attributes['url_image'];
            if ($url_image != null or $url_image != '') {
                $url_image = $this->storageHelper->getUrlImgEmployee($url_image);
            }
            return $url_image;
        }
    }

    public function gettypeDocumentAttribute()
    {
        if (isset($this->attributes['typedocument_id'])) {
            $type = new TypeDocumentRepository();
            $data_type = $type->find($this->attributes['typedocument_id']);
            return $data_type['description'];
        }
    }

    public function getjobassignedAttribute()
    {

        if (isset($this->attributes['companyjob_id'])) {
            $job= new CompanyJobRepository();
            $data_type = $job->find($this->attributes['companyjob_id']);
            return $data_type['description'];
        }
    }

    public function getassignedbranchsAttribute()
    {
        $rAssignedBranch = new AssignedBranchRepository() ;
        $branchs = $rAssignedBranch->findByEmployee($this->attributes['id']);
        return $branchs;
    }
}
